/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.PromotionDto;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.ProductPromotion;
import com.chataak.api.entity.Products;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OrganizationStoreRepository;
import com.chataak.api.repo.ProductPromotionRepository;
import com.chataak.api.repo.ProductsRepository;
import com.chataak.api.service.ProductPromotionsService;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductPromotionsServiceImpl
implements ProductPromotionsService {
    @Autowired
    private ProductPromotionRepository productPromotionRepository;
    @Autowired
    private ProductsRepository productsRepository;
    @Autowired
    private OrganizationStoreRepository organizationStoreRepository;

    public List<PromotionDto> getAllPromotionsByStoreKey(Integer storeKeyId, Long productKeyId) {
        OrganizationStore organizationStore = (OrganizationStore)this.organizationStoreRepository.findById((Object)storeKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, the store you are looking for is currently unavailable. Please try again later."));
        Products scannedProduct = (Products)this.productsRepository.findById((Object)productKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, we couldn't find any product associated with the scanned barcode. Please make sure you've scanned the correct barcode."));
        Integer orgId = organizationStore.getOrganization().getId();
        String storeCountry = organizationStore.getCountry();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        String storeCity = organizationStore.getCity();
        String storeState = organizationStore.getState();
        List<String> productCategories = scannedProduct.getCategories().stream().map(CategoryManager::getName).toList();
        LinkedHashSet productPromotions = new LinkedHashSet();
        Set storePromotions = this.productPromotionRepository.findPromotionsByStoreAndProductOrCategories(orgId, id, storeKeyId, "store", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(storePromotions);
        Set cityPromotions = this.productPromotionRepository.findPromotionsByCityAndProductOrCategories(orgId, id, storeCity, "city", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(cityPromotions);
        Set statePromotions = this.productPromotionRepository.findPromotionsByStateAndProductOrCategories(orgId, id, storeState, "state", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(statePromotions);
        Set countryPromotions = this.productPromotionRepository.findPromotionsByCountryAndProductOrCategories(orgId, id, storeCountry, "country", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(countryPromotions);
        List<PromotionDto> resultPromotions = productPromotions.stream().map(dto -> this.mapToDto(dto, storeKeyId.intValue(), organizationStore.getStoreDisplayName())).collect(Collectors.toList());
        return resultPromotions;
    }

    public List<PromotionDto> getAllPromotionsByStore(Integer storeKeyId) {
        OrganizationStore organizationStore = (OrganizationStore)this.organizationStoreRepository.findById((Object)storeKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, the store you are looking for is currently unavailable. Please try again later."));
        Integer orgId = organizationStore.getOrganization().getId();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        Date now = new Date();
        Set productPromotions = Stream.of(this.productPromotionRepository.findPromotionsByAll(orgId, id, organizationStore.getCountry(), organizationStore.getState(), organizationStore.getCity(), storeKeyId, Short.valueOf((short)1), now, now)).flatMap(Collection::stream).collect(Collectors.toSet());
        return productPromotions.parallelStream().filter(promotion -> promotion.getImageURL() != null).map(dto -> this.mapToDto(dto, storeKeyId.intValue(), organizationStore.getStoreDisplayName())).collect(Collectors.toList());
    }

    private PromotionDto mapToDto(ProductPromotion productPromotion, int storId, String storeName) {
        PromotionDto dto = new PromotionDto();
        dto.setStoreKeyId(Integer.valueOf(storId));
        dto.setPromotionKeyId(productPromotion.getPromotionId());
        dto.setStoreName(storeName);
        dto.setValidTill(productPromotion.getValidTill());
        dto.setPromotionDesc(productPromotion.getDescription());
        dto.setDiscountAmount(productPromotion.getPromotionAmount());
        dto.setValidFrom(productPromotion.getValidFrom());
        String s = productPromotion.getImageURL();
        if (s != null && !s.isEmpty()) {
            String filename = s.substring(s.lastIndexOf("/") + 1);
            dto.setImageURL("https://dev-api.chataak.in/images/" + filename);
        } else {
            dto.setImageURL(null);
        }
        dto.setDiscountPercentage(productPromotion.getPromotionPercentage());
        dto.setPromotionCode(productPromotion.getPromotionCode());
        dto.setPromotionDesc(productPromotion.getDescription());
        return dto;
    }

    public int countOffersByStoreKey(Integer storeKeyId, Long productKeyId) {
        OrganizationStore organizationStore = (OrganizationStore)this.organizationStoreRepository.findById((Object)storeKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, the store you are looking for is currently unavailable. Please try again later."));
        Products scannedProduct = (Products)this.productsRepository.findById((Object)productKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, we couldn't find any product associated with the scanned barcode. Please make sure you've scanned the correct barcode."));
        Integer orgId = organizationStore.getOrganization().getId();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        String storeCountry = organizationStore.getCountry();
        String storeCity = organizationStore.getCity();
        String storeState = organizationStore.getState();
        List<String> productCategories = scannedProduct.getCategories().stream().map(CategoryManager::getName).toList();
        LinkedHashSet productPromotions = new LinkedHashSet();
        Set storePromotions = this.productPromotionRepository.findPromotionsByStoreAndProductOrCategories(orgId, id, storeKeyId, "store", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(storePromotions);
        Set cityPromotions = this.productPromotionRepository.findPromotionsByCityAndProductOrCategories(orgId, id, storeCity, "city", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(cityPromotions);
        Set statePromotions = this.productPromotionRepository.findPromotionsByStateAndProductOrCategories(orgId, id, storeState, "state", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(statePromotions);
        Set countryPromotions = this.productPromotionRepository.findPromotionsByCountryAndProductOrCategories(orgId, id, storeCountry, "country", Short.valueOf((short)1), new Date(), new Date(), productKeyId, productCategories).stream().collect(Collectors.toSet());
        productPromotions.addAll(countryPromotions);
        return productPromotions.size();
    }

    public int countOffersByStore(Integer storeKeyId) {
        OrganizationStore organizationStore = (OrganizationStore)this.organizationStoreRepository.findById((Object)storeKeyId).orElseThrow(() -> new ResourceNotFoundException("Sorry, the store you are looking for is currently unavailable. Please try again later."));
        Integer orgId = organizationStore.getOrganization().getId();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        String storeCountry = organizationStore.getCountry();
        String storeCity = organizationStore.getCity();
        String storeState = organizationStore.getState();
        LinkedHashSet productPromotions = new LinkedHashSet();
        Set storePromotions = this.productPromotionRepository.findPromotionsByStore(orgId, id, storeKeyId, "store", Short.valueOf((short)1), new Date(), new Date()).stream().collect(Collectors.toSet());
        productPromotions.addAll(storePromotions);
        Set cityPromotions = this.productPromotionRepository.findPromotionsByCity(orgId, id, storeCity, "city", Short.valueOf((short)1), new Date(), new Date()).stream().collect(Collectors.toSet());
        productPromotions.addAll(cityPromotions);
        Set statePromotions = this.productPromotionRepository.findPromotionsByStates(orgId, id, storeState, "state", Short.valueOf((short)1), new Date(), new Date()).stream().collect(Collectors.toSet());
        productPromotions.addAll(statePromotions);
        Set countryPromotions = this.productPromotionRepository.findPromotionsByCountry(orgId, id, storeCountry, "country", Short.valueOf((short)1), new Date(), new Date()).stream().collect(Collectors.toSet());
        productPromotions.addAll(countryPromotions);
        return productPromotions.size();
    }
}

