/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.OrganizationStoreDto;
import com.chataak.api.dto.OrganizationStoreListDto;
import com.chataak.api.entity.Organization;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.ShoppingCart;
import com.chataak.api.entity.User;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OrganizationRepository;
import com.chataak.api.repo.OrganizationStoreRepository;
import com.chataak.api.repo.ShoppingCartRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.OrganizationStoreService;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class OrganizationStoreServiceImpl
implements OrganizationStoreService {
    @Autowired
    private OrganizationStoreRepository organizationStoreRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ShoppingCartRepository shoppingCartRepository;
    @Autowired
    private OrganizationRepository organizationRepository;

    public OrganizationStoreDto createOrganizationStore(int organizationId, OrganizationStoreDto organizationStoreDto) {
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new ResourceNotFoundException("Organization not found with id " + organizationId));
        OrganizationStore organizationStore = this.convertToEntity(organizationStoreDto);
        organizationStore.setOrganization(organization);
        OrganizationStore savedStore = (OrganizationStore)this.organizationStoreRepository.save((Object)organizationStore);
        return this.convertToDto(savedStore);
    }

    private OrganizationStore convertToEntity(OrganizationStoreDto organizationStoreDto) {
        ModelMapper modelMapper = new ModelMapper();
        return (OrganizationStore)modelMapper.map((Object)organizationStoreDto, OrganizationStore.class);
    }

    private OrganizationStoreDto convertToDto(OrganizationStore organizationStore) {
        ModelMapper modelMapper = new ModelMapper();
        return (OrganizationStoreDto)modelMapper.map((Object)organizationStore, OrganizationStoreDto.class);
    }

    public List<OrganizationStoreListDto> getAllStores() {
        boolean ACTIVE_STATUS = true;
        boolean ZERO = false;
        Date now = new Date();
        List organizationStores = this.organizationStoreRepository.findValidOrganizationStores((short)1);
        String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        User currentUser = (User)this.userRepository.findByMobileNumber(username).orElseThrow(() -> new ResourceNotFoundException("User not found"));
        Map<Integer, Integer> activeCartsByStore = this.shoppingCartRepository.findActiveCartsByUser(currentUser.getUserKeyId().intValue()).parallelStream().collect(Collectors.toMap(cart -> cart.getStore().getStoreKeyId(), ShoppingCart::getCartKeyId));
        return organizationStores.parallelStream().filter(store -> store.getOrganization().getOrganizationType() != 0).filter(store -> store.getOrganization().getSubscriptionValidTill().after(now) || store.getOrganization().getInfinitePlan() != false).sorted(Comparator.comparing(OrganizationStore::getStoreDisplayName).thenComparing(store -> store.getOrganization().getDisplayName())).map(store -> this.convertToListDto(store, activeCartsByStore)).collect(Collectors.toList());
    }

    private OrganizationStoreListDto convertToListDto(OrganizationStore store, Map<Integer, Integer> activeCartsByStore) {
        OrganizationStoreListDto dto = new OrganizationStoreListDto();
        dto.setStoreKeyId(store.getStoreKeyId());
        String displayName = store.getStoreUniqueName() + " (" + (store.getCity() != null ? store.getCity() : (!store.isMerchantIn() ? store.getOrganization().getDisplayName() : store.getMerchantId().getDisplayName())) + ")";
        dto.setStoreDisplayName(displayName);
        dto.setActiveCartKeyId(activeCartsByStore.getOrDefault(store.getStoreKeyId(), 0));
        return dto;
    }
}

