/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.OrganizationStoreCouponsDto;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.OrganizationStoreCoupons;
import com.chataak.api.entity.ShoppingCart;
import com.chataak.api.entity.ShoppingCartProducts;
import com.chataak.api.entity.User;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OrganizationStoreCouponsRepository;
import com.chataak.api.repo.OrganizationStoreRepository;
import com.chataak.api.repo.ShoppingCartProductsRepository;
import com.chataak.api.repo.ShoppingCartRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.OrganizationStoreCouponsService;
import jakarta.persistence.EntityNotFoundException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class OrganizationStoreCouponsServiceImpl
implements OrganizationStoreCouponsService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationStoreCouponsServiceImpl.class);
    private final OrganizationStoreCouponsRepository organizationStoreCouponsRepository;
    private final OrganizationStoreRepository organizationStoreRepository;
    private final UserRepository userRepository;
    private final ShoppingCartProductsRepository cartProductsRepository;
    private final ShoppingCartRepository shoppingCartRepository;

    @Autowired
    public OrganizationStoreCouponsServiceImpl(OrganizationStoreCouponsRepository organizationStoreCouponsRepository, OrganizationStoreRepository organizationStoreRepository, UserRepository userRepository, ShoppingCartProductsRepository cartProductsRepository, ShoppingCartRepository shoppingCartRepository) {
        this.organizationStoreCouponsRepository = organizationStoreCouponsRepository;
        this.organizationStoreRepository = organizationStoreRepository;
        this.userRepository = userRepository;
        this.cartProductsRepository = cartProductsRepository;
        this.shoppingCartRepository = shoppingCartRepository;
    }

    public Set<OrganizationStoreCouponsDto> getCouponsByStoreKeyId(Integer storeKeyId, Integer cartKeyId) {
        ShoppingCart cart = (ShoppingCart)this.shoppingCartRepository.findById((Object)cartKeyId).orElseThrow(() -> new ResourceNotFoundException("Shopping Cart not found"));
        String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        User currentUser = (User)this.userRepository.findByMobileNumber(username).orElseThrow(() -> new BadCredentialsException("User not found"));
        if (!cart.getUser().equals((Object)currentUser)) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        List cartProducts = this.cartProductsRepository.findByShoppingCart(cart);
        if (cartProducts.isEmpty()) {
            return Collections.emptySet();
        }
        BigDecimal totalCartValue = cartProducts.stream().map(ShoppingCartProducts::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        OrganizationStore store = cart.getStore();
        Integer orgId = store.getOrganization().getId();
        Integer merchantOrOrgId = store.getMerchantId() != null ? store.getMerchantId().getId() : store.getOrganization().getId();
        String storeCountry = store.getCountry();
        String storeCity = store.getCity();
        String storeState = store.getState();
        Date currentDate = new Date();
        Set<OrganizationStoreCouponsDto> couponDtos = cartProducts.parallelStream().flatMap(product -> {
            Long productKeyId = product.getProduct().getProductId();
            List productCategories = product.getProduct().getCategories().parallelStream().map(CategoryManager::getName).collect(Collectors.toList());
            List couponsForProduct = this.organizationStoreCouponsRepository.findCouponsByAllAndProductOrCategories(orgId, merchantOrOrgId, storeCountry, storeState, storeCity, storeKeyId, (short)1, currentDate, currentDate, productKeyId, productCategories);
            List genericCoupons = this.organizationStoreCouponsRepository.findCouponsByAll(orgId, merchantOrOrgId, storeCountry, storeState, storeCity, storeKeyId, (short)1, currentDate, currentDate);
            return Stream.concat(couponsForProduct.stream(), genericCoupons.stream());
        }).map(arg_0 -> this.mapToDto(arg_0)).peek(dto -> {
            if (dto.isBillAmountBased()) {
                boolean applicable = totalCartValue.compareTo(dto.getBillAmountFrom()) >= 0 && totalCartValue.compareTo(dto.getBillAmountTo()) <= 0;
                dto.setCoupon(applicable);
            } else {
                dto.setCoupon(true);
            }
            boolean applied = cart.getCoupons() != null && cart.getCoupons().getCouponKeyId().equals(dto.getCouponKeyId());
            dto.setApplied(applied);
        }).collect(Collectors.toSet());
        logger.info("Total cart value: " + String.valueOf(totalCartValue));
        return couponDtos;
    }

    public OrganizationStoreCouponsDto mapToDto(OrganizationStoreCoupons coupon) {
        OrganizationStoreCouponsDto dto = new OrganizationStoreCouponsDto();
        dto.setCouponKeyId(coupon.getCouponKeyId());
        dto.setCouponName(coupon.getCouponName());
        dto.setCouponCode(coupon.getCouponCode());
        dto.setCouponDescription(coupon.getCouponDescription());
        dto.setCouponStartDate(coupon.getCouponStartDate());
        dto.setCouponEndDate(coupon.getCouponEndDate());
        dto.setCouponPercentage(coupon.getCouponPercentage());
        dto.setCouponAmount(coupon.getCouponAmount());
        dto.setCouponType(coupon.getCouponType());
        dto.setBillAmountBased(coupon.isBillAmountBased());
        dto.setBillAmountFrom(coupon.getBillAmountFrom());
        dto.setBillAmountTo(coupon.getBillAmountTo());
        String imageUrl = coupon.getImageURL();
        if (imageUrl != null && !imageUrl.isEmpty()) {
            String filename = imageUrl.substring(imageUrl.lastIndexOf("/") + 1);
            dto.setImageURL("https://dev-api.chataak.in/images/" + filename);
        } else {
            dto.setImageURL(null);
        }
        return dto;
    }

    public String getCoupon(Integer cartKeyId, Long couponKeyId) {
        BigDecimal percentage;
        BigDecimal amount;
        BigDecimal bigDecimal;
        List shoppingCartProducts;
        Optional coupon;
        String username;
        Optional userToken;
        ShoppingCart cart = (ShoppingCart)this.shoppingCartRepository.findById((Object)cartKeyId).orElseThrow(() -> new ResourceNotFoundException("Shopping Cart not found"));
        User user = cart.getUser();
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        OrganizationStoreCoupons coupons = null;
        if (cart.getCoupons() != null) {
            coupons = cart.getCoupons();
        }
        if (couponKeyId != null && !couponKeyId.equals(0) && (coupon = this.organizationStoreCouponsRepository.findById((Object)couponKeyId)).isPresent() && (coupons = (OrganizationStoreCoupons)coupon.get()).getCouponStatus() != 1) {
            coupons = null;
        }
        if ((shoppingCartProducts = this.cartProductsRepository.findByShoppingCart(cart)) == null || shoppingCartProducts.isEmpty()) {
            throw new EntityNotFoundException("Shopping cart products are empty");
        }
        HashMap cartSummary = new HashMap();
        BigDecimal totalCartValue = BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ZERO;
        for (ShoppingCartProducts products : shoppingCartProducts) {
            BigDecimal totalAmount = products.getTotalAmount();
            Integer quantity = products.getQuantity();
            totalCartValue = totalCartValue.add(totalAmount);
            discount = discount.add(products.getDiscountAmount());
        }
        logger.info("totalCartValue-" + String.valueOf(totalCartValue));
        BigDecimal totalCoupon = bigDecimal = new BigDecimal("0.00");
        BigDecimal couponPercentage = bigDecimal;
        BigDecimal couponAmount = bigDecimal;
        if (coupons != null && coupons.isBillAmountBased() && totalCartValue.compareTo(coupons.getBillAmountFrom()) >= 0 && totalCartValue.compareTo(coupons.getBillAmountTo()) <= 0) {
            amount = coupons.getCouponAmount();
            percentage = coupons.getCouponPercentage();
            if (percentage != null) {
                couponPercentage = percentage;
                logger.info("couponPercentage-" + String.valueOf(couponPercentage));
            }
            if (amount != null) {
                couponAmount = amount;
                logger.info("couponAmount-" + String.valueOf(couponAmount));
            }
        }
        if (coupons != null && !coupons.isBillAmountBased()) {
            amount = coupons.getCouponAmount();
            percentage = coupons.getCouponPercentage();
            if (percentage != null) {
                couponPercentage = percentage;
                logger.info("couponPercentage-" + String.valueOf(couponPercentage));
            }
            if (amount != null) {
                couponAmount = amount;
                logger.info("couponAmount 2-" + String.valueOf(couponAmount));
            }
        }
        if (!couponAmount.equals(bigDecimal)) {
            logger.info("totalCoupon -");
            totalCoupon = couponAmount;
            logger.info("totalCoupon -" + String.valueOf(totalCoupon));
        } else {
            logger.info("totalCoupon 2-");
            totalCoupon = totalCartValue.multiply(couponPercentage.divide(new BigDecimal("100")));
            logger.info("totalCoupon 2-" + String.valueOf(totalCoupon));
        }
        if (totalCoupon.setScale(2, RoundingMode.HALF_UP).equals(bigDecimal) || totalCoupon.equals(BigDecimal.ZERO)) {
            coupons = null;
        }
        System.out.println(totalCoupon);
        cart.setCoupons(coupons);
        cart.setCouponAmount(totalCoupon.setScale(2, RoundingMode.HALF_UP));
        ShoppingCart save = (ShoppingCart)this.shoppingCartRepository.save((Object)cart);
        if (coupons != null) {
            return "Coupon applied successfully";
        }
        return null;
    }
}

