/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.OrderBillDTO;
import com.chataak.api.dto.OrderDto;
import com.chataak.api.dto.OrderListDTO;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.Order;
import com.chataak.api.entity.OrderNumber;
import com.chataak.api.entity.OrderProducts;
import com.chataak.api.entity.OrderProductsKeyId;
import com.chataak.api.entity.PaymentTransaction;
import com.chataak.api.entity.ProductImage;
import com.chataak.api.entity.Products;
import com.chataak.api.entity.SessionHistory;
import com.chataak.api.entity.ShoppingCart;
import com.chataak.api.entity.ShoppingCartProducts;
import com.chataak.api.entity.User;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.CategoryManagerRepository;
import com.chataak.api.repo.OrderNumberRepository;
import com.chataak.api.repo.OrderPaymentRepository;
import com.chataak.api.repo.OrderProductsRepository;
import com.chataak.api.repo.OrderRepository;
import com.chataak.api.repo.PaymentTransactionRepo;
import com.chataak.api.repo.SessionHistoryRepository;
import com.chataak.api.repo.ShoppingCartProductsRepository;
import com.chataak.api.repo.ShoppingCartRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.OrderService;
import jakarta.persistence.EntityNotFoundException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private OrderProductsRepository orderProductsRepository;
    @Autowired
    private ModelMapper mapper;
    @Autowired
    private ShoppingCartProductsRepository shoppingCartProductsRepository;
    @Autowired
    private ShoppingCartRepository shoppingCartRepository;
    @Autowired
    private OrderNumberRepository orderNumberRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SessionHistoryRepository historyRepository;
    @Autowired
    private PaymentTransactionRepo paymentTransactionRepo;
    @Autowired
    private OrderPaymentRepository orderPaymentRepository;
    @Autowired
    private CategoryManagerRepository categoryManagerRepository;

    public Map<String, Object> createOrder(int userKeyId, Integer cartKeyId) {
        OrderNumber orderNumber;
        List shoppingCartProducts;
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        ShoppingCart cart = (ShoppingCart)this.shoppingCartRepository.findById((Object)cartKeyId).orElseThrow(() -> new EntityNotFoundException("Shopping cart not found"));
        List histories = this.historyRepository.findByUser(user);
        SessionHistory sessionHistory = null;
        if (!histories.isEmpty()) {
            sessionHistory = (SessionHistory)histories.get(histories.size() - 1);
        }
        if ((shoppingCartProducts = this.shoppingCartProductsRepository.findByShoppingCart(cart)) == null || shoppingCartProducts.isEmpty()) {
            throw new EntityNotFoundException("Shopping cart products are empty");
        }
        Order order = new Order();
        order.setUser(user);
        order.setCreatedOn(new Date());
        order.setShoppingCart(cart);
        order.setOrganization(cart.getStore().isMerchantIn() ? cart.getStore().getMerchantId() : cart.getStore().getOrganization());
        order.setCreatedBy(Integer.valueOf(userKeyId));
        order.setSessionHistory(sessionHistory);
        order.setOrderDate(new Date());
        order.setStore(cart.getStore());
        order.setCoupons(cart.getCoupons());
        order.setTotalAmount(cart.getPaymentTransaction().getAmount().setScale(2, RoundingMode.HALF_UP));
        order.setCouponAmount(cart.getCouponAmount().setScale(2, RoundingMode.HALF_UP));
        short shorts = 30;
        order.setStatus(shorts);
        String configId = "ORD";
        Optional orderNo = this.orderNumberRepository.findById((Object)configId);
        if (orderNo.isPresent()) {
            orderNumber = (OrderNumber)orderNo.get();
        } else {
            orderNumber = new OrderNumber();
            orderNumber.setOrderNo(configId);
            orderNumber.setNextOrderNumber(1);
            orderNumber = (OrderNumber)this.orderNumberRepository.save((Object)orderNumber);
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        String currentYear = yearFormat.format(new Date());
        int nextOrderNumber = orderNumber.getNextOrderNumber();
        String formattedNextOrderNumber = String.format("%04d", nextOrderNumber);
        String orderNumbers = currentYear + "/" + formattedNextOrderNumber;
        order.setOrderNo(orderNumbers);
        orderNumber.setNextOrderNumber(nextOrderNumber + 1);
        this.orderNumberRepository.save((Object)orderNumber);
        BigDecimal totalCartValue = BigDecimal.ZERO;
        Order newOrder = (Order)this.orderRepository.save((Object)order);
        for (ShoppingCartProducts cartProducts : shoppingCartProducts) {
            if (!cartProducts.isInStock()) continue;
            BigDecimal totalAmount = cartProducts.getTotalAmount();
            totalCartValue = totalCartValue.add(totalAmount);
            OrderProducts orderProducts = new OrderProducts();
            OrderProductsKeyId id = new OrderProductsKeyId();
            id.setOrder(newOrder);
            id.setProducts(cartProducts.getProduct());
            orderProducts.setId(id);
            orderProducts.setOrder(newOrder);
            orderProducts.setProducts(cartProducts.getProduct());
            orderProducts.setStore(cartProducts.getShoppingCart().getStore());
            orderProducts.setQuantity(cartProducts.getQuantity());
            orderProducts.setSellingPriceCurrency(cartProducts.getSellingPriceCurrency());
            orderProducts.setSellingUOM(cartProducts.getSellingUOM());
            orderProducts.setOrignalPrice(cartProducts.getOrignalPrice().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setActualSellingPrice(cartProducts.getActualSellingPrice().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setPromotion(cartProducts.getPromotion());
            orderProducts.setDiscountPercentage(cartProducts.getDiscountPercentage());
            orderProducts.setDiscountAmount(cartProducts.getDiscountAmount().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setPromoDiscountAmount(cartProducts.getPromoDiscountAmount().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setCgstRate(cartProducts.getCgstRate());
            orderProducts.setSgstRate(cartProducts.getSgstRate());
            orderProducts.setCreatedOn(new Date());
            orderProducts.setTaxableAmount(cartProducts.getTaxableAmount().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setCgstAmount(cartProducts.getCgstAmount());
            orderProducts.setSgstAmount(cartProducts.getSgstAmount());
            orderProducts.setSpInclusiveTax(cartProducts.getSpInclusiveTax());
            orderProducts.setDisplayAmount(cartProducts.getDisplayAmount().setScale(2, RoundingMode.HALF_UP));
            orderProducts.setNetAmount(cartProducts.getTotalAmount());
            orderProducts.setCartSessionID(cartProducts.getSessionHistory().getSessionKeyId());
            this.orderProductsRepository.save((Object)orderProducts);
        }
        PaymentTransaction paymentTransaction = cart.getPaymentTransaction();
        newOrder.setTotalAmount(paymentTransaction.getAmount());
        this.orderRepository.save((Object)newOrder);
        paymentTransaction.setOrder(newOrder);
        this.paymentTransactionRepo.save((Object)paymentTransaction);
        cart.setCartCompletedOn(new Date());
        Short aShort = 0;
        cart.setStatus(aShort.shortValue());
        this.shoppingCartRepository.save((Object)cart);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", 1);
        map.put("message", "success");
        map.put("orderNo", newOrder.getOrderNo());
        map.put("cartKeyId", 0);
        return map;
    }

    public void updateOrder(int userKeyId, Order order, int orderKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        Order existingOrder = (Order)this.orderRepository.findById((Object)orderKeyId).orElseThrow(() -> new ResourceNotFoundException("Order not found" + orderKeyId));
        if (existingOrder != null && existingOrder.getUser().getUserKeyId() != null && existingOrder.getUser().getUserKeyId().equals(userKeyId)) {
            if (existingOrder.getStore() == null || existingOrder.getStore().getStoreKeyId() == null) {
                throw new ResourceNotFoundException("Invalid storeKeyId associated with the order");
            }
        } else {
            throw new ResourceNotFoundException("Unauthorized to update this order");
        }
        existingOrder.setModifiedBy(order.getModifiedBy());
        existingOrder.setStatus(order.getStatus());
        existingOrder.setModifiedOn(new Date());
        this.orderRepository.save((Object)existingOrder);
    }

    public OrderBillDTO getOrderBill(int userKeyID, Long orderKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyID).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyID));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        Optional optional = this.orderRepository.findById((Object)orderKeyId);
        ArrayList orderDtos = new ArrayList();
        if (optional.isEmpty()) {
            throw new ResourceNotFoundException("order not found");
        }
        Order order = (Order)optional.get();
        BigDecimal totalCartValue = BigDecimal.ZERO;
        int itemCount = 0;
        BigDecimal taxableAmount = BigDecimal.ZERO;
        BigDecimal tax1Value = BigDecimal.ZERO;
        BigDecimal tax2Value = BigDecimal.ZERO;
        BigDecimal tax3Value = BigDecimal.ZERO;
        BigDecimal tax4Value = BigDecimal.ZERO;
        ArrayList image = new ArrayList();
        List shoppingCartProducts = this.orderProductsRepository.findByOrder(order);
        if (shoppingCartProducts == null || shoppingCartProducts.isEmpty()) {
            throw new EntityNotFoundException("order not found");
        }
        for (OrderProducts products : shoppingCartProducts) {
            BigDecimal totalAmount = products.getNetAmount();
            Integer quantity = products.getQuantity();
            BigDecimal taxableAmounts = products.getTaxableAmount().setScale(2, RoundingMode.HALF_UP);
            BigDecimal CGST = BigDecimal.valueOf(products.getCgstAmount()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal SGST = BigDecimal.valueOf(products.getSgstAmount()).setScale(2, RoundingMode.HALF_UP);
            totalCartValue = totalCartValue.add(totalAmount).setScale(2, RoundingMode.HALF_UP);
            itemCount += quantity.intValue();
            taxableAmount = taxableAmount.add(taxableAmounts).setScale(2, RoundingMode.HALF_UP);
            tax1Value = tax1Value.add(SGST).setScale(2, RoundingMode.HALF_UP);
            tax2Value = tax2Value.add(CGST).setScale(2, RoundingMode.HALF_UP);
            List productImages = products.getProducts().getProductImages();
            ArrayList<CallSite> imageURLs = new ArrayList<CallSite>();
            if (productImages == null || productImages.isEmpty()) continue;
            for (ProductImage productImage : productImages) {
                String imageURL = productImage.getImageUrl();
                if (imageURL == null || imageURL.isEmpty()) continue;
                String filename = imageURL.substring(imageURL.lastIndexOf("/") + 1);
                imageURLs.add((CallSite)((Object)("https://dev-api.chataak.in/images/thumbnail/" + filename)));
            }
        }
        OrderBillDTO dto = new OrderBillDTO();
        dto.setBill(totalCartValue.setScale(2, RoundingMode.HALF_UP));
        dto.setTaxableAmount(taxableAmount.setScale(2, RoundingMode.HALF_UP));
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (order.getCoupons() != null) {
            if (order.getCoupons().getCouponAmount() != null && !order.getCoupons().getCouponAmount().equals(bigDecimal) && !order.getCoupons().getCouponAmount().equals(0)) {
                dto.setCouponOffAmount(order.getCoupons().getCouponAmount().setScale(2, RoundingMode.HALF_UP));
            } else {
                dto.setCouponOffAmount(bigDecimal);
            }
        } else {
            dto.setCouponOffAmount(bigDecimal);
        }
        if (order.getCoupons() != null) {
            if (order.getCoupons().getCouponPercentage() != null && !order.getCoupons().getCouponPercentage().equals(bigDecimal) && !order.getCoupons().getCouponPercentage().equals(0)) {
                dto.setCouponOffPercentage(order.getCoupons().getCouponPercentage());
            } else {
                dto.setCouponOffPercentage(bigDecimal);
            }
        } else {
            dto.setCouponOffPercentage(bigDecimal);
        }
        if (order.getCoupons() != null) {
            dto.setCouponOffer(order.getCouponAmount().setScale(2, RoundingMode.HALF_UP));
        } else {
            dto.setCouponOffer(bigDecimal);
        }
        if (order.getCoupons() != null) {
            dto.setCouponName(order.getCoupons().getCouponName());
        } else {
            dto.setCouponName(null);
        }
        dto.setPaymentType(order.getShoppingCart().getPaymentTransaction().getMethodType());
        if (order.getCoupons() != null) {
            dto.setIsCouponApplied(Boolean.valueOf(true));
        } else {
            dto.setIsCouponApplied(Boolean.valueOf(false));
        }
        BigDecimal couponAmount = bigDecimal;
        if (order.getCouponAmount() != null) {
            couponAmount = order.getCouponAmount().setScale(2, RoundingMode.HALF_UP);
        }
        dto.setPayAmount(totalCartValue.subtract(couponAmount).setScale(2, RoundingMode.HALF_UP));
        BigDecimal tax1Scale = tax1Value.setScale(2, RoundingMode.HALF_UP);
        BigDecimal tax2Scale = tax2Value.setScale(2, RoundingMode.HALF_UP);
        BigDecimal tax3Scale = tax3Value.setScale(2, RoundingMode.HALF_UP);
        BigDecimal tax4Scale = tax4Value.setScale(2, RoundingMode.HALF_UP);
        BigDecimal zero = new BigDecimal("0");
        BigDecimal zero1 = new BigDecimal("0.0");
        BigDecimal zero2 = new BigDecimal("0.00");
        if (!(tax1Scale.equals(zero) || tax1Scale.equals(zero1) || tax1Scale.equals(zero2))) {
            dto.setTax1DisplayName("SGST");
            dto.setTax1Value(tax1Scale.setScale(2, RoundingMode.HALF_UP));
        } else {
            dto.setTax1DisplayName(null);
            dto.setTax1Value(null);
        }
        if (!(tax2Scale.equals(zero) || tax2Scale.equals(zero1) || tax2Scale.equals(zero2))) {
            dto.setTax2DisplayName("CGST");
            dto.setTax2Value(tax2Scale.setScale(2, RoundingMode.HALF_UP));
        } else {
            dto.setTax2DisplayName(null);
            dto.setTax2Value(null);
        }
        return dto;
    }

    public List<OrderDto> getOrderInfo(int userKeyID, Long orderKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyID).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyID));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        Optional optional = this.orderRepository.findById((Object)orderKeyId);
        ArrayList<OrderDto> orderDtos = new ArrayList<OrderDto>();
        if (optional.isEmpty()) {
            return orderDtos;
        }
        Order order = (Order)optional.get();
        List shoppingCartProducts = this.orderProductsRepository.findByOrder(order).stream().sorted(Comparator.comparing(OrderProducts::getCreatedOn)).collect(Collectors.toList());
        for (OrderProducts products : shoppingCartProducts) {
            OrderDto orderDto = new OrderDto();
            List categories = products.getProducts().getCategories();
            int categoryIndex = 0;
            if (products.getProducts().getBrand() != null) {
                orderDto.setCategory1(products.getProducts().getBrand().getName());
                orderDto.setDisplayNameCategory1("Brand");
                ++categoryIndex;
            }
            for (int i = 0; i < categories.size() && categoryIndex < 3; ++i, ++categoryIndex) {
                if (((CategoryManager)categories.get(i)).getName() != null && ((CategoryManager)categories.get(i)).getLabel() != null) {
                    if (categoryIndex == 1) {
                        orderDto.setCategory2(((CategoryManager)categories.get(i)).getName());
                        orderDto.setDisplayNameCategory2(((CategoryManager)categories.get(i)).getLabel());
                        continue;
                    }
                    if (categoryIndex == 2) {
                        orderDto.setCategory3(((CategoryManager)categories.get(i)).getName());
                        orderDto.setDisplayNameCategory3(((CategoryManager)categories.get(i)).getLabel());
                        continue;
                    }
                    if (categoryIndex != 0) continue;
                    orderDto.setCategory1(((CategoryManager)categories.get(i)).getName());
                    orderDto.setDisplayNameCategory1(((CategoryManager)categories.get(i)).getLabel());
                    ++categoryIndex;
                    continue;
                }
                --categoryIndex;
            }
            if (categoryIndex < 1) {
                orderDto.setCategory1(null);
                orderDto.setDisplayNameCategory1(null);
            }
            if (categoryIndex < 2) {
                orderDto.setCategory2(null);
                orderDto.setDisplayNameCategory2(null);
            }
            if (categoryIndex < 3) {
                orderDto.setCategory3(null);
                orderDto.setDisplayNameCategory3(null);
            }
            orderDto.setOrderNo(order.getOrderNo());
            Date orderDate = order.getOrderDate();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            String formattedDate = dateFormat.format(orderDate);
            orderDto.setBoughtOn(formattedDate);
            orderDto.setQuantity(products.getQuantity().intValue());
            orderDto.setActualPrice(products.getOrignalPrice().setScale(2, RoundingMode.HALF_UP));
            orderDto.setSellingPrice(products.getActualSellingPrice().setScale(2, RoundingMode.HALF_UP));
            orderDto.setTotalAmount(products.getDisplayAmount().setScale(2, RoundingMode.HALF_UP));
            if (order.getCoupons() != null) {
                orderDto.setCouponName(order.getCoupons().getCouponName());
            } else {
                orderDto.setCouponName(null);
            }
            orderDto.setStoreName(order.getStore().getStoreDisplayName());
            orderDto.setDiscountAmount(products.getDiscountAmount());
            orderDto.setDiscountPercentage(products.getDiscountPercentage());
            List productImages = products.getProducts().getProductImages();
            ArrayList<CallSite> imageURLs = new ArrayList<CallSite>();
            if (productImages != null && !productImages.isEmpty()) {
                for (ProductImage productImage : productImages) {
                    String imageURL = productImage.getImageUrl();
                    if (imageURL == null || imageURL.isEmpty()) continue;
                    String filename = imageURL.substring(imageURL.lastIndexOf("/") + 1);
                    imageURLs.add((CallSite)((Object)("https://dev-api.chataak.in/images/thumbnail/" + filename)));
                }
            }
            if (imageURLs.isEmpty()) {
                orderDto.setImage("https://dev-api.chataak.in/images/profile/no_image_available.png");
            } else {
                orderDto.setImage((String)imageURLs.get(0));
            }
            orderDto.setStoreKeyId(order.getStore().getStoreKeyId());
            orderDto.setProductKeyId(products.getProducts().getProductId());
            orderDto.setProductDescription(products.getProducts().getProductDescription());
            orderDto.setPaymentType(order.getShoppingCart().getPaymentTransaction().getMethodType());
            BigDecimal bigDecimal = new BigDecimal("0.00");
            if (order.getCoupons() != null) {
                if (order.getCoupons().getCouponAmount() != null && !order.getCoupons().getCouponAmount().equals(bigDecimal) && !order.getCoupons().getCouponAmount().equals(0)) {
                    orderDto.setCouponOffAmount(order.getCoupons().getCouponAmount().setScale(2, RoundingMode.HALF_UP));
                } else {
                    orderDto.setCouponOffAmount(bigDecimal);
                }
            } else {
                orderDto.setCouponOffAmount(bigDecimal);
            }
            if (order.getCoupons() != null) {
                if (order.getCoupons().getCouponPercentage() != null && !order.getCoupons().getCouponPercentage().equals(bigDecimal) && !order.getCoupons().getCouponPercentage().equals(0)) {
                    orderDto.setCouponOffPercentage(order.getCoupons().getCouponPercentage());
                } else {
                    orderDto.setCouponOffPercentage(bigDecimal);
                }
            } else {
                orderDto.setCouponOffPercentage(bigDecimal);
            }
            if (order.getCoupons() != null) {
                orderDto.setCouponOffer(order.getCouponAmount().setScale(2, RoundingMode.HALF_UP));
            } else {
                orderDto.setCouponOffer(bigDecimal);
            }
            orderDtos.add(orderDto);
        }
        return orderDtos;
    }

    private List<String> getCategoriesFromCategoryManager(Products product) {
        return this.categoryManagerRepository.findCategoriesByProductId(product.getProductId()).stream().map(CategoryManager::getName).collect(Collectors.toList());
    }

    public List<OrderListDTO> getAllOrderList(Integer userKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        List orderList = this.orderRepository.findByUser(user);
        orderList.sort(Comparator.comparing(Order::getOrderDate).reversed());
        logger.info(" order List is sort");
        return orderList.stream().filter(f -> f.getShoppingCart().getPaymentTransaction() != null).map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
    }

    public OrderListDTO toDto(Order order) {
        OrderListDTO dto = new OrderListDTO();
        dto.setOrderId(order.getOrderKeyId().longValue());
        dto.setOrderNumber(order.getOrderNo());
        dto.setStoreName(order.getStore().getStoreDisplayName());
        String city = order.getStore().getCity();
        String state = order.getStore().getState();
        String country = order.getStore().getCountry();
        if (city != null && state != null) {
            dto.setStoreLocation(city + ", " + state + ".");
            dto.setPlace(city);
        } else if (city != null) {
            dto.setStoreLocation(city + ".");
            dto.setPlace(city);
        } else if (state != null) {
            dto.setStoreLocation(state + ".");
        } else if (country != null) {
            dto.setStoreLocation(country + ".");
        } else {
            dto.setStoreLocation("");
        }
        logger.info("setStoreName");
        Date orderDate = order.getOrderDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        String formattedDate = dateFormat.format(orderDate);
        dto.setBoughtOn(formattedDate);
        logger.info("setBoughtOn");
        BigDecimal totalCartValue = BigDecimal.ZERO;
        int itemCount = 0;
        BigDecimal discount = BigDecimal.ZERO;
        ArrayList<Object> imageUrls = new ArrayList<Object>();
        List shoppingCartProducts = this.orderProductsRepository.findByOrder(order);
        for (OrderProducts products : shoppingCartProducts) {
            BigDecimal totalAmount = products.getNetAmount();
            Integer quantity = products.getQuantity();
            totalCartValue = totalCartValue.add(totalAmount);
            itemCount += quantity.intValue();
            discount = discount.add(products.getDiscountAmount());
            List productImages = products.getProducts().getProductImages();
            if (productImages == null || productImages.isEmpty()) continue;
            Object imageUrl = ((ProductImage)productImages.get(0)).getImageUrl();
            String filename = ((String)imageUrl).substring(((String)imageUrl).lastIndexOf("/") + 1);
            imageUrl = "https://dev-api.chataak.in/images/thumbnail/" + filename;
            imageUrls.add(imageUrl);
        }
        dto.setImages(imageUrls);
        logger.info(order.getShoppingCart().getPaymentTransaction().getMethodType());
        dto.setPaymentType(order.getShoppingCart().getPaymentTransaction().getMethodType());
        dto.setDiscountAmount(discount);
        logger.info(" discount-" + String.valueOf(discount));
        BigDecimal couponAmount = BigDecimal.ZERO;
        if (order.getCouponAmount() != null) {
            couponAmount = order.getCouponAmount();
            logger.info("couponAmount-" + String.valueOf(couponAmount));
        }
        dto.setTotalAmount(totalCartValue.subtract(couponAmount).setScale(2, RoundingMode.HALF_UP));
        logger.info("TotalAmount-" + String.valueOf(dto.getTotalAmount()));
        dto.setItemCount(shoppingCartProducts.size());
        if (order.getCoupons() != null) {
            dto.setCouponName(order.getCoupons().getCouponName());
            logger.info(" setCouponName");
        } else {
            dto.setCouponName(null);
        }
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (order.getCoupons() != null) {
            if (order.getCoupons().getCouponAmount() != null && !order.getCoupons().getCouponAmount().equals(bigDecimal) && !order.getCoupons().getCouponAmount().equals(0)) {
                dto.setCouponOffAmount(order.getCoupons().getCouponAmount());
                logger.info("setCouponOffAmount");
            } else {
                dto.setCouponOffAmount(bigDecimal);
            }
        } else {
            dto.setCouponOffAmount(bigDecimal);
        }
        if (order.getCoupons() != null) {
            if (order.getCoupons().getCouponPercentage() != null && !order.getCoupons().getCouponPercentage().equals(bigDecimal) && !order.getCoupons().getCouponPercentage().equals(0)) {
                dto.setCouponOffPercentage(order.getCoupons().getCouponPercentage());
                logger.info(" setCouponOffPercentage");
            } else {
                dto.setCouponOffPercentage(bigDecimal);
            }
        } else {
            dto.setCouponOffPercentage(bigDecimal);
        }
        if (order.getCoupons() != null) {
            dto.setCouponOffer(order.getCouponAmount());
        } else {
            dto.setCouponOffer(bigDecimal);
        }
        dto.setStatus(order.getStatus());
        return dto;
    }
}

