/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.ValidateOTPDTO;
import com.chataak.api.entity.OTP;
import com.chataak.api.entity.OrderNumber;
import com.chataak.api.entity.SessionHistory;
import com.chataak.api.entity.User;
import com.chataak.api.exception.MobileNumberAlreadyExistsException;
import com.chataak.api.exception.MobileNumberInvalidException;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OTPRepository;
import com.chataak.api.repo.OrderNumberRepository;
import com.chataak.api.repo.SessionHistoryRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.JwtService;
import com.chataak.api.service.OTPService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OTPServiceImpl
implements OTPService {
    @Autowired
    private OTPRepository otpRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private OrderNumberRepository orderNumberRepository;
    @Autowired
    private SessionHistoryRepository historyRepository;

    public String generateOTP() {
        int otpValue = new Random().nextInt(9000) + 1000;
        return String.format("%04d", otpValue);
    }

    public OTP generateAndSaveOTP(String mobileNumber, String ipAddress) {
        if (mobileNumber.length() != 10 || mobileNumber == null || mobileNumber.equals("")) {
            throw new MobileNumberInvalidException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        Optional mobileNumbers = this.userRepository.findByMobileNumber(mobileNumber);
        if (mobileNumbers.isPresent() && ((User)mobileNumbers.get()).getStatus() == 20) {
            throw new MobileNumberAlreadyExistsException("Your Mobile No. " + mobileNumber + " has been blocked by Chataak. Please contact the Chataak support team for assistance.");
        }
        String value = this.generateOTP();
        OTP otp = new OTP();
        otp.setMobileNumber(mobileNumber);
        otp.setUser(null);
        if (ipAddress != null) {
            otp.setIpAddress(ipAddress);
        }
        otp.setOtp("1234");
        otp.setGeneratedTime(LocalDateTime.now());
        otp.setExpiryTime(LocalDateTime.now().plusMinutes(1L));
        otp.setUtilized(Boolean.valueOf(false));
        return (OTP)this.otpRepository.save((Object)otp);
    }

    public OTP resendOtp(String mobileNumber, String ipAddress) {
        if (mobileNumber.length() != 10 || mobileNumber == null || mobileNumber.equals("")) {
            throw new MobileNumberInvalidException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        Optional otpListOptional = this.otpRepository.findByMobileNumber(mobileNumber);
        List otpList = otpListOptional.orElseGet(ArrayList::new);
        if (!otpList.isEmpty()) {
            OTP lastOtp = (OTP)otpList.get(otpList.size() - 1);
            if (LocalDateTime.now().isBefore(lastOtp.getExpiryTime())) {
                return lastOtp;
            }
            OTP newOtp = new OTP();
            newOtp.setMobileNumber(mobileNumber);
            if (ipAddress != null) {
                newOtp.setIpAddress(ipAddress);
            }
            newOtp.setOtp("1234");
            newOtp.setGeneratedTime(LocalDateTime.now());
            newOtp.setExpiryTime(LocalDateTime.now().plusMinutes(1L));
            newOtp.setUtilized(Boolean.valueOf(false));
            return (OTP)this.otpRepository.save((Object)newOtp);
        }
        throw new ResourceNotFoundException("Please Register a Valid Mobile number");
    }

    public ValidateOTPDTO OTPAsUtilized(String mobileNo, String otp) {
        if (mobileNo == null || mobileNo.trim().isEmpty() || mobileNo.length() != 10) {
            throw new MobileNumberInvalidException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        if (otp == null || otp.length() != 4) {
            throw new MobileNumberAlreadyExistsException("Invalid OTP. Please provide a 4-digit OTP number.");
        }
        List otpList = (List)this.otpRepository.findByMobileNumber(mobileNo).orElseThrow(() -> new ResourceNotFoundException("Please register a valid mobile number"));
        OTP lastOtp = (OTP)otpList.stream().reduce((first, second) -> second).orElseThrow(() -> new ResourceNotFoundException("No OTP available"));
        if (!lastOtp.getOtp().equals(otp) || lastOtp.getUtilized().booleanValue()) {
            throw new ResourceNotFoundException("Invalid OTP");
        }
        if (LocalDateTime.now().isAfter(lastOtp.getExpiryTime())) {
            throw new ResourceNotFoundException("OTP is expired");
        }
        lastOtp.setUtilized(Boolean.valueOf(true));
        lastOtp.setUtilizedTime(LocalDateTime.now());
        User user = this.userRepository.findByMobileNumber(mobileNo).orElseGet(() -> {
            User newUser = new User();
            newUser.setMobileNumber(mobileNo);
            newUser.setCreatedOn(new Date());
            newUser.setStatus(User.UserStatus.ACTIVE);
            newUser.setDeletedBy(null);
            newUser.setDeletedOn(null);
            newUser.setModifiedBy(null);
            newUser.setModifiedOn(null);
            newUser.setCusUniqueId(this.generateUniqueId("CHACUS"));
            return (User)this.userRepository.save((Object)newUser);
        });
        user.setStatus(User.UserStatus.ACTIVE);
        user = (User)this.userRepository.save((Object)user);
        lastOtp.setUser(user);
        ValidateOTPDTO validateOTPDTO = this.buildValidateOTPDTO(user);
        SessionHistory sessionHistory = new SessionHistory();
        sessionHistory.setUser(user);
        sessionHistory.setIpAddress(lastOtp.getIpAddress());
        sessionHistory.setLoginDateTime(new Date());
        this.historyRepository.save((Object)sessionHistory);
        this.otpRepository.save((Object)lastOtp);
        return validateOTPDTO;
    }

    private ValidateOTPDTO buildValidateOTPDTO(User user) {
        ValidateOTPDTO dto = new ValidateOTPDTO();
        String imageURL = user.getImageURL();
        if (imageURL != null && !imageURL.isEmpty()) {
            String filename = imageURL.substring(imageURL.lastIndexOf("/") + 1);
            dto.setImageURL("https://dev-api.chataak.in/images/staffprofile/" + filename);
        } else {
            dto.setImageURL("https://dev-api.chataak.in/images/profile/default.png");
        }
        dto.setEmailId(user.getEmailId());
        dto.setMobileNumber(user.getMobileNumber());
        dto.setUserKeyId(user.getUserKeyId());
        dto.setDisplayName(user.getDisplayName());
        dto.setStatus(1);
        dto.setMessage("Success");
        return dto;
    }

    public String generatePreLoginToken(String ipAddress) {
        if (ipAddress == null || ipAddress.equals("")) {
            throw new MobileNumberAlreadyExistsException("Please provide a IPAddress.");
        }
        String token = this.jwtService.generateTokens(ipAddress);
        return token;
    }

    private String generateUniqueId(String id) {
        OrderNumber orderNumber = (OrderNumber)this.orderNumberRepository.findById((Object)id).orElseThrow(() -> new IllegalStateException("customer number not available"));
        Object orderNo = orderNumber.getOrderNo();
        orderNo = orderNumber.getNextOrderNumber() < 10 ? (String)orderNo + "0" + orderNumber.getNextOrderNumber() : (String)orderNo + orderNumber.getNextOrderNumber();
        orderNumber.setNextOrderNumber(orderNumber.getNextOrderNumber() + 1);
        this.orderNumberRepository.save((Object)orderNumber);
        return orderNo;
    }
}

