/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class JwtService {
    @Value(value="${jwt.secret}")
    private String SECRET;
    private List<String> revokedTokens = new ArrayList();

    public String extractUsername(String token) {
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    public Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }

    public <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    private Claims extractAllClaims(String token) {
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(this.getSignKey()).build().parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            throw new BadCredentialsException("Invalid Token received");
        }
    }

    private Boolean isTokenExpired(String token) {
        try {
            return this.extractExpiration(token).before(new Date());
        }
        catch (Exception e) {
            throw new BadCredentialsException("Expired Token received");
        }
    }

    public String generateToken(String mobileNumber) {
        HashMap claims = new HashMap();
        return this.createToken(claims, mobileNumber);
    }

    private String createToken(Map<String, Object> claims, String mobileNumber) {
        return Jwts.builder().setIssuer("chataak").setClaims(claims).setSubject(mobileNumber).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(this.generateExpirationDate()).signWith(this.getSignKey(), SignatureAlgorithm.HS256).compact();
    }

    private String createTokens(Map<String, Object> claims, String mobileNumber) {
        return Jwts.builder().setIssuer("chataak").setClaims(claims).setSubject(mobileNumber).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(this.generateExpirationDates()).signWith(this.getSignKey(), SignatureAlgorithm.HS256).compact();
    }

    private String createToken(Map<String, Object> claims, String mobileNumber, Date expirationDate) {
        return Jwts.builder().setIssuer("chataak").setClaims(claims).setSubject(mobileNumber).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(expirationDate).signWith(this.getSignKey(), SignatureAlgorithm.HS256).compact();
    }

    public String generateTokens(String mobileNumber) {
        HashMap claims = new HashMap();
        return this.createTokens(claims, mobileNumber);
    }

    private Key getSignKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.SECRET);
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    public String generateExpiredToken() {
        HashMap claims = new HashMap();
        return this.createToken(claims, "", new Date(0L));
    }

    public void revokeToken(String token) {
        this.revokedTokens.add(token);
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        String username = this.extractUsername(token);
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false && this.isTokenRevoked(token) == false;
    }

    public Boolean validateTokens(String token) {
        String username = this.extractUsername(token);
        return this.isTokenExpired(token) == false && this.isTokenRevoked(token) == false;
    }

    private Boolean isTokenRevoked(String token) {
        return this.revokedTokens.contains(token);
    }

    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + 3155695200000L);
    }

    private Date generateExpirationDates() {
        return new Date(System.currentTimeMillis() + 3600000L);
    }
}

