/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.repo;

import com.chataak.api.entity.Brand;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.OrganizationStoreEntity;
import com.chataak.api.entity.Products;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OrganizationStoreEntityRepository
extends JpaRepository<OrganizationStoreEntity, Integer>,
JpaSpecificationExecutor<OrganizationStoreEntity> {
    public List<OrganizationStoreEntity> findByStore(OrganizationStore var1);

    public List<OrganizationStoreEntity> findByStore_StoreKeyId(Integer var1);

    public List<OrganizationStoreEntity> findByStoreAndProductsIn(OrganizationStore var1, List<Products> var2);

    @Query(value="SELECT ose FROM OrganizationStoreEntity ose JOIN ose.products p WHERE ose.store = :store AND p.productId IN :productIds")
    public List<OrganizationStoreEntity> findProductIdsByStoreAndProductsIn(@Param(value="store") OrganizationStore var1, @Param(value="productIds") List<Long> var2);

    @Query(value="SELECT * FROM catalog_product_stores cps WHERE cps.store_key_id = :storeKeyId AND cps.product_id = :productId LIMIT 1", nativeQuery=true)
    public Optional<OrganizationStoreEntity> findByStoreAndProducts(@Param(value="storeKeyId") Integer var1, @Param(value="productId") Long var2);

    public List<OrganizationStoreEntity> findByProducts(Products var1);

    @Query(value="SELECT ose.* FROM catalog_product_stores ose INNER JOIN catalog_products p ON ose.product_id = p.product_id WHERE ose.store_key_id = :storeKeyId AND p.bar_code = :barcode LIMIT 1", nativeQuery=true)
    public OrganizationStoreEntity findByProductsBarCodeAndStore(@Param(value="barcode") String var1, @Param(value="storeKeyId") Integer var2);

    @Query(value="SELECT ose FROM OrganizationStoreEntity ose JOIN ose.store s JOIN ose.products p WHERE s = :store AND ose.status = :status AND p.status = :status AND EXISTS (SELECT c FROM p.categories c WHERE c IN :categories) AND p.productId <> :excludedProductId")
    public List<OrganizationStoreEntity> findSimilarProductsByStoreAndCategories(@Param(value="store") OrganizationStore var1, @Param(value="status") Short var2, @Param(value="categories") List<CategoryManager> var3, @Param(value="excludedProductId") Long var4);

    @Query(value="SELECT ose FROM OrganizationStoreEntity ose JOIN ose.store s JOIN ose.products p WHERE s = :store AND ose.status = :status AND p.status = :status AND p.brand = :brand AND p.productId <> :excludedProductId")
    public List<OrganizationStoreEntity> findByStoresAndStatusAndBrand(@Param(value="store") OrganizationStore var1, @Param(value="status") Short var2, @Param(value="brand") Brand var3, @Param(value="excludedProductId") Long var4);

    @Query(value="SELECT ose FROM OrganizationStoreEntity ose JOIN ose.products p WHERE ose.store = :store AND ose.status = :status AND p.status = :status AND (p.brand = :brand OR EXISTS (SELECT 1 FROM p.categories c WHERE c IN :categories)) AND p.productId <> :excludedProductId")
    public List<OrganizationStoreEntity> findSimilarProducts(@Param(value="store") OrganizationStore var1, @Param(value="status") Short var2, @Param(value="categories") List<CategoryManager> var3, @Param(value="brand") Brand var4, @Param(value="excludedProductId") Long var5);
}

