/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.entity;

import com.chataak.api.entity.Organization;
import com.chataak.api.entity.TaxClass;
import com.fasterxml.jackson.annotation.JsonBackReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="tax_rule")
public class TaxRule {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="tax_rule_id")
    private Long taxRuleId;
    @Column(name="tax_name", length=35, nullable=false)
    private String taxName;
    @Column(name="tax_rate")
    private double taxRate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id", referencedColumnName="organizationKeyId", nullable=false)
    @JsonBackReference
    private Organization organization;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tax_class_id")
    private TaxClass taxClass;
    @Column(name="country", length=3)
    private String country;
    @Column(name="state", length=100)
    private String state;

    public Long getTaxRuleId() {
        return this.taxRuleId;
    }

    public String getTaxName() {
        return this.taxName;
    }

    public double getTaxRate() {
        return this.taxRate;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public TaxClass getTaxClass() {
        return this.taxClass;
    }

    public String getCountry() {
        return this.country;
    }

    public String getState() {
        return this.state;
    }

    public void setTaxRuleId(Long taxRuleId) {
        this.taxRuleId = taxRuleId;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public void setTaxRate(double taxRate) {
        this.taxRate = taxRate;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setTaxClass(TaxClass taxClass) {
        this.taxClass = taxClass;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxRule)) {
            return false;
        }
        TaxRule other = (TaxRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getTaxRate(), other.getTaxRate()) != 0) {
            return false;
        }
        Long this$taxRuleId = this.getTaxRuleId();
        Long other$taxRuleId = other.getTaxRuleId();
        if (this$taxRuleId == null ? other$taxRuleId != null : !((Object)this$taxRuleId).equals(other$taxRuleId)) {
            return false;
        }
        String this$taxName = this.getTaxName();
        String other$taxName = other.getTaxName();
        if (this$taxName == null ? other$taxName != null : !this$taxName.equals(other$taxName)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        TaxClass this$taxClass = this.getTaxClass();
        TaxClass other$taxClass = other.getTaxClass();
        if (this$taxClass == null ? other$taxClass != null : !this$taxClass.equals(other$taxClass)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaxRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $taxRate = Double.doubleToLongBits(this.getTaxRate());
        result = result * 59 + (int)($taxRate >>> 32 ^ $taxRate);
        Long $taxRuleId = this.getTaxRuleId();
        result = result * 59 + ($taxRuleId == null ? 43 : ((Object)$taxRuleId).hashCode());
        String $taxName = this.getTaxName();
        result = result * 59 + ($taxName == null ? 43 : $taxName.hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        TaxClass $taxClass = this.getTaxClass();
        result = result * 59 + ($taxClass == null ? 43 : $taxClass.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    public String toString() {
        return "TaxRule(taxRuleId=" + this.getTaxRuleId() + ", taxName=" + this.getTaxName() + ", taxRate=" + this.getTaxRate() + ", organization=" + String.valueOf(this.getOrganization()) + ", taxClass=" + String.valueOf(this.getTaxClass()) + ", country=" + this.getCountry() + ", state=" + this.getState() + ")";
    }

    public TaxRule() {
    }

    public TaxRule(Long taxRuleId, String taxName, double taxRate, Organization organization, TaxClass taxClass, String country, String state) {
        this.taxRuleId = taxRuleId;
        this.taxName = taxName;
        this.taxRate = taxRate;
        this.organization = organization;
        this.taxClass = taxClass;
        this.country = country;
        this.state = state;
    }
}

