/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.entity;

import com.chataak.api.entity.Order;
import com.chataak.api.entity.Organization;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name="payment_transactions")
public class PaymentTransaction {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="transaction_id")
    private Long transactionId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="order_id", referencedColumnName="orderKeyId")
    private Order order;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", referencedColumnName="userKeyId")
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="store_id", referencedColumnName="store_key_id")
    private OrganizationStore store;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="org_id", referencedColumnName="organizationKeyId")
    private Organization organization;
    @Column(name="method_type")
    private String methodType;
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="status")
    private Short status;
    @Column(name="payment_id")
    private String paymentId;
    @Column(name="order_payment_id")
    private String orderPaymentId;
    @Column(name="transaction_date")
    private LocalDateTime transactionDate;
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public Long getTransactionId() {
        return this.transactionId;
    }

    public Order getOrder() {
        return this.order;
    }

    public User getUser() {
        return this.user;
    }

    public OrganizationStore getStore() {
        return this.store;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public String getMethodType() {
        return this.methodType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getOrderPaymentId() {
        return this.orderPaymentId;
    }

    public LocalDateTime getTransactionDate() {
        return this.transactionDate;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setStore(OrganizationStore store) {
        this.store = store;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setMethodType(String methodType) {
        this.methodType = methodType;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setOrderPaymentId(String orderPaymentId) {
        this.orderPaymentId = orderPaymentId;
    }

    public void setTransactionDate(LocalDateTime transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentTransaction)) {
            return false;
        }
        PaymentTransaction other = (PaymentTransaction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$transactionId = this.getTransactionId();
        Long other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !((Object)this$transactionId).equals(other$transactionId)) {
            return false;
        }
        Short this$status = this.getStatus();
        Short other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Order this$order = this.getOrder();
        Order other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        OrganizationStore this$store = this.getStore();
        OrganizationStore other$store = other.getStore();
        if (this$store == null ? other$store != null : !this$store.equals(other$store)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$methodType = this.getMethodType();
        String other$methodType = other.getMethodType();
        if (this$methodType == null ? other$methodType != null : !this$methodType.equals(other$methodType)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$orderPaymentId = this.getOrderPaymentId();
        String other$orderPaymentId = other.getOrderPaymentId();
        if (this$orderPaymentId == null ? other$orderPaymentId != null : !this$orderPaymentId.equals(other$orderPaymentId)) {
            return false;
        }
        LocalDateTime this$transactionDate = this.getTransactionDate();
        LocalDateTime other$transactionDate = other.getTransactionDate();
        if (this$transactionDate == null ? other$transactionDate != null : !((Object)this$transactionDate).equals(other$transactionDate)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : ((Object)$transactionId).hashCode());
        Short $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Order $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        OrganizationStore $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : $store.hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $methodType = this.getMethodType();
        result = result * 59 + ($methodType == null ? 43 : $methodType.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $orderPaymentId = this.getOrderPaymentId();
        result = result * 59 + ($orderPaymentId == null ? 43 : $orderPaymentId.hashCode());
        LocalDateTime $transactionDate = this.getTransactionDate();
        result = result * 59 + ($transactionDate == null ? 43 : ((Object)$transactionDate).hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentTransaction(transactionId=" + this.getTransactionId() + ", order=" + String.valueOf(this.getOrder()) + ", user=" + String.valueOf(this.getUser()) + ", store=" + String.valueOf(this.getStore()) + ", organization=" + String.valueOf(this.getOrganization()) + ", methodType=" + this.getMethodType() + ", amount=" + String.valueOf(this.getAmount()) + ", status=" + this.getStatus() + ", paymentId=" + this.getPaymentId() + ", orderPaymentId=" + this.getOrderPaymentId() + ", transactionDate=" + String.valueOf(this.getTransactionDate()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    public PaymentTransaction(Long transactionId, Order order, User user, OrganizationStore store, Organization organization, String methodType, BigDecimal amount, Short status, String paymentId, String orderPaymentId, LocalDateTime transactionDate, LocalDateTime createdAt, LocalDateTime updatedAt) {
        this.transactionId = transactionId;
        this.order = order;
        this.user = user;
        this.store = store;
        this.organization = organization;
        this.methodType = methodType;
        this.amount = amount;
        this.status = status;
        this.paymentId = paymentId;
        this.orderPaymentId = orderPaymentId;
        this.transactionDate = transactionDate;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public PaymentTransaction() {
    }
}

