/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.PromotionDto;
import com.chataak.api.service.ProductPromotionsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/store"})
public class ProductPromotionsController {
    private static final Logger logger = LoggerFactory.getLogger(ProductPromotionsController.class);
    @Autowired
    private ProductPromotionsService productPromotionsServiceImpl;

    @GetMapping(value={"/{storeKeyId}/{productKeyId}/offer"})
    public ResponseEntity<List<PromotionDto>> getPromotionsByStoreKey(@PathVariable Integer storeKeyId, @PathVariable Long productKeyId) {
        logger.info("Received Get Promotions request /api/store/{storeKeyId}/{productKeyId}/offers with storeKeyId-{" + storeKeyId + "}&productKeyId{" + productKeyId + "}");
        List allPromotionsByStoreKey = this.productPromotionsServiceImpl.getAllPromotionsByStoreKey(storeKeyId, productKeyId);
        logger.info("Get Promotions request successful.");
        return ResponseEntity.ok((Object)allPromotionsByStoreKey);
    }

    @GetMapping(value={"/{storeKeyId}/{productKeyId}/offer/count"})
    public ResponseEntity<Map<String, Integer>> countOffersByStoreKey(@PathVariable Integer storeKeyId, @PathVariable Long productKeyId) {
        logger.info("Received Count Offers request /api/store/{storeKeyId}/{productKeyId}/offers/count with storeKeyId-{" + storeKeyId + "}&productKeyId{" + productKeyId + "}");
        int offerCount = this.productPromotionsServiceImpl.countOffersByStoreKey(storeKeyId, productKeyId);
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        response.put("offerCount", offerCount);
        logger.info("Count Offers request successful.");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{storeKeyId}/offers"})
    public ResponseEntity<List<PromotionDto>> getPromotionsByStore(@PathVariable Integer storeKeyId) {
        logger.info("Received Get Promotions request /api/store/{storeKeyId}/offers with storeKeyId-{" + storeKeyId + "}");
        List allPromotionsByStoreKey = this.productPromotionsServiceImpl.getAllPromotionsByStore(storeKeyId);
        logger.info("Get Promotions request successful.");
        return ResponseEntity.ok((Object)allPromotionsByStoreKey);
    }

    @GetMapping(value={"/{storeKeyId}/offers/count"})
    public ResponseEntity<Map<String, Integer>> countOffersByStore(@PathVariable Integer storeKeyId) {
        logger.info("Received Count Offers request /api/store/{storeKeyId}/offers/count with storeKeyId-{" + storeKeyId + "}");
        int offerCount = this.productPromotionsServiceImpl.countOffersByStore(storeKeyId);
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        response.put("offerCount", offerCount);
        logger.info("Count Offers request successful.");
        return ResponseEntity.ok(response);
    }
}

