/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.ResponseOTP;
import com.chataak.api.dto.ValidateOTPDTO;
import com.chataak.api.entity.OTP;
import com.chataak.api.exception.MobileNumberAlreadyExistsException;
import com.chataak.api.service.JwtService;
import com.chataak.api.service.OTPService;
import com.chataak.api.service.RequestService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class OtpController {
    private static final Logger logger = LoggerFactory.getLogger(OtpController.class);
    @Autowired
    private OTPService otpService;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private RequestService requestService;
    @Value(value="${api.secret}")
    private String SECRET;

    @PostMapping(value={"/sendOTP"})
    public ResponseEntity<ResponseOTP> generateOTP(@RequestBody Map<String, String> request, @RequestHeader(name="APIKey") String apiKey) {
        String mobileNumber = request.get("mobileNumber");
        logger.info("Received Generate OTP request /api/auth/sendOTP with mobile Number" + mobileNumber);
        if (apiKey == null && !apiKey.startsWith("Bearer ")) {
            logger.warn("Generate OTP Token request APIKey InValid.");
            throw new MobileNumberAlreadyExistsException("APIKey is InValid");
        }
        String token = apiKey.substring(7);
        String ipAddress = this.jwtService.extractUsername(token);
        logger.info("Received request ipAddress:" + ipAddress + "& mobileNumber:" + mobileNumber);
        if (!this.jwtService.validateTokens(token).booleanValue()) {
            logger.warn("Generate OTP Token request APIKey InValid.");
            throw new MobileNumberAlreadyExistsException("APIKey is InValid");
        }
        OTP otp = this.otpService.generateAndSaveOTP(mobileNumber, ipAddress);
        ResponseOTP responseOTP = new ResponseOTP();
        responseOTP.setStatus(Integer.valueOf(1));
        responseOTP.setMessage("success");
        logger.info("Generate OTP request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @PostMapping(value={"/sendOTP/resend"})
    public ResponseEntity<ResponseOTP> getResendOTP(@RequestBody Map<String, String> request) {
        String mobileNumber = request.get("mobileNumber");
        logger.info("Received Resend OTP request /api/auth/sendOTP/resend with mobile Number" + mobileNumber);
        String ipAddress = request.get("ipAddress");
        OTP otp = this.otpService.resendOtp(mobileNumber, ipAddress);
        if (otp != null) {
            ResponseOTP responseOTP = new ResponseOTP();
            responseOTP.setStatus(Integer.valueOf(1));
            responseOTP.setMessage("success");
            logger.info("Resend OTP request successful.");
            return ResponseEntity.ok((Object)responseOTP);
        }
        logger.warn("Resend OTP request error.");
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/validateOTP"})
    public ResponseEntity<ValidateOTPDTO> getValidOTP(@RequestBody Map<String, String> request) {
        logger.info("Received Validate OTP request /api/auth/validateOTP");
        String mobileNumber = request.get("mobileNumber");
        String otp = request.get("OTP");
        logger.info("Received Validate OTP request /api/auth/validateOTP with mobile Number-" + mobileNumber);
        ValidateOTPDTO validateOTPDTO = this.otpService.OTPAsUtilized(mobileNumber, otp);
        String token = this.jwtService.generateToken(mobileNumber);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + token);
        logger.info("Validate OTP request successful.");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)validateOTPDTO);
    }

    @PostMapping(value={"/GeneratePreLoginToken"})
    public ResponseEntity<ResponseOTP> generatePreLoginToken(@RequestHeader(name="X-API-KEY") String apiKey, HttpServletRequest request) {
        logger.info("Received Generate PreLogin Token request /api/auth/GeneratePreLoginToken");
        if (apiKey != null && apiKey.equals(this.SECRET)) {
            String ipAddress = this.requestService.getClientIp(request);
            logger.info("Received Generate PreLogin Token request ipAddress:" + ipAddress);
            String preLoginToken = this.otpService.generatePreLoginToken(ipAddress);
            ResponseOTP responseOTP = new ResponseOTP();
            responseOTP.setStatus(Integer.valueOf(1));
            responseOTP.setMessage("success");
            HttpHeaders headers = new HttpHeaders();
            headers.add("APIKey", "Bearer " + preLoginToken);
            logger.info("Generate PreLogin Token request successful.");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)responseOTP);
        }
        logger.warn("Generate PreLogin Token request APIKey InValid.");
        throw new MobileNumberAlreadyExistsException("APIKey is InValid");
    }
}

