/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.controller.OrganizationController;
import com.chataak.api.dto.OrganizationStoreCouponsDto;
import com.chataak.api.dto.ResponseOTP;
import com.chataak.api.service.OrganizationStoreCouponsService;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrganizationStoreCouponsController {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationController.class);
    private final OrganizationStoreCouponsService organizationStoreCouponsService;

    @Autowired
    public OrganizationStoreCouponsController(OrganizationStoreCouponsService organizationStoreCouponsService) {
        this.organizationStoreCouponsService = organizationStoreCouponsService;
    }

    @GetMapping(value={"/api/store/{storeKeyId}/{cartKeyId}/coupons"})
    public ResponseEntity<Set<OrganizationStoreCouponsDto>> getCouponsByStoreKeyId(@PathVariable Integer storeKeyId, @PathVariable Integer cartKeyId) {
        logger.info("getCouponsByStoreKeyId /api/store/{storeKeyId}/coupons");
        Set coupons = this.organizationStoreCouponsService.getCouponsByStoreKeyId(storeKeyId, cartKeyId);
        logger.info("getCouponsByStoreKeyId successful.");
        return new ResponseEntity((Object)coupons, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/api/store/{cartKeyId}/coupons/{couponKeyId}"})
    public ResponseEntity<?> addingCoupon(@PathVariable Integer cartKeyId, @PathVariable Long couponKeyId) {
        logger.info("Adding Coupon /api/store/{cartKeyId}" + cartKeyId + "/coupons/{couponKeyId}" + couponKeyId);
        String coupons = this.organizationStoreCouponsService.getCoupon(cartKeyId, couponKeyId);
        ResponseOTP responseOTP = new ResponseOTP();
        if (coupons != null) {
            responseOTP.setStatus(Integer.valueOf(1));
            responseOTP.setMessage(coupons);
            logger.info("Adding Coupon request successful.");
        } else {
            responseOTP.setStatus(Integer.valueOf(0));
            responseOTP.setMessage("Coupon cannot be applied.");
            logger.info("Adding Coupon request not successful.");
        }
        return new ResponseEntity((Object)responseOTP, (HttpStatusCode)HttpStatus.OK);
    }
}

