/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.OrganizationStoreDto;
import com.chataak.api.dto.OrganizationStoreListDto;
import com.chataak.api.service.OrganizationStoreService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/store"})
public class OrganizationController {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationController.class);
    @Autowired
    private OrganizationStoreService organizationStoreServiceImpl;

    @PostMapping(value={"/{organizationId}/stores"})
    public ResponseEntity<OrganizationStoreDto> createOrganizationStore(@PathVariable int organizationId, @RequestBody OrganizationStoreDto organizationStoreDto) {
        logger.info("Received Create Organization Store request /api/store/{organizationId}/stores");
        OrganizationStoreDto createdStore = this.organizationStoreServiceImpl.createOrganizationStore(organizationId, organizationStoreDto);
        logger.info("Create Organization Store request successful.");
        return ResponseEntity.ok((Object)createdStore);
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<OrganizationStoreListDto>> getAllStores() {
        logger.info("Received Get All Stores request /api/store/list");
        List storeDtos = this.organizationStoreServiceImpl.getAllStores();
        logger.info("Get All Stores request successful.");
        return ResponseEntity.ok((Object)storeDtos);
    }
}

