/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.ResponseOTP;
import com.chataak.api.dto.UserDTO;
import com.chataak.api.entity.User;
import com.chataak.api.exception.MobileNumberAlreadyExistsException;
import com.chataak.api.exception.MobileNumberInvalidException;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OTPRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.UserService;
import com.chataak.api.service.impl.OTPServiceImpl;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.hibernate.ResourceClosedException;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private OTPServiceImpl otpService;
    @Autowired
    private OTPRepository otpRepository;
    private UserRepository userRepository;
    private ModelMapper mapper;

    @Autowired
    public UserServiceImpl(UserRepository userRepository, ModelMapper mapper) {
        this.userRepository = userRepository;
        this.mapper = mapper;
    }

    public List<User> getAllUsers() {
        return this.userRepository.findAll();
    }

    public UserDTO getUserById(int userId) {
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceClosedException("UserId not found" + userId));
        return this.mapToDTO(user);
    }

    public UserDTO createUser(UserDTO userDTO) {
        if (userDTO.getMobileNumber().length() != 10 || userDTO.getMobileNumber() == null || userDTO.getMobileNumber().equals("")) {
            throw new MobileNumberAlreadyExistsException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        User user = this.mapToEntity(userDTO);
        user.setCreatedOn(new Date());
        user.setDeletedBy(null);
        user.setDeletedOn(null);
        user.setModifiedBy(null);
        user.setModifiedOn(null);
        Optional mobileNumber = this.userRepository.findByMobileNumber(user.getMobileNumber());
        if (mobileNumber.isPresent()) {
            throw new ResourceNotFoundException("Mobile Number already register");
        }
        User newUser = (User)this.userRepository.save((Object)user);
        UserDTO dto = this.mapToDTO(newUser);
        return dto;
    }

    public UserDTO userUpdateFile(int userId, MultipartFile file) throws Exception {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceClosedException("User not found with id: " + userId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        if (file != null && !file.isEmpty()) {
            File uploadDir;
            String previousImagePath = user.getImageURL();
            if (previousImagePath != null && !previousImagePath.isEmpty()) {
                File previousImageFile = new File(previousImagePath);
                FileUtils.forceDelete((File)previousImageFile);
            }
            String fileName = StringUtils.cleanPath((String)file.getOriginalFilename());
            String currentWorkingDirectory = System.getProperty("user.dir");
            String uploadPath = "/var/www/dev-api.chataak.in/images/staffprofile/";
            Object uniqueFileName = userId + "_" + System.currentTimeMillis() + "_" + fileName.replace(" ", "_");
            if (((String)uniqueFileName).length() > 100) {
                uniqueFileName = ((String)uniqueFileName).substring(0, 55);
            }
            if (!(uploadDir = new File(uploadPath)).exists()) {
                uploadDir.mkdirs();
            }
            String filePath = uploadPath + (String)uniqueFileName;
            File dest = new File(filePath);
            file.transferTo(dest);
            user.setImageURL(filePath);
        }
        User updatedUser = (User)this.userRepository.save((Object)user);
        return this.mapToDTO(updatedUser);
    }

    public UserDTO updateUser(int userId, UserDTO userDTO) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceClosedException("User not found with id: " + userId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        if (this.userRepository.existsByMobileNumberAndUserKeyIdNot(userDTO.getMobileNumber(), userId)) {
            throw new MobileNumberAlreadyExistsException("Mobile Number is already registered.");
        }
        if (userDTO.getMobileNumber().length() != 10 || userDTO.getMobileNumber() == null || userDTO.getMobileNumber().equals("")) {
            throw new MobileNumberAlreadyExistsException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        String mobileNumber = userDTO.getMobileNumber();
        if (mobileNumber.length() != 10 || mobileNumber == null || mobileNumber.equals("")) {
            throw new MobileNumberInvalidException("Incorrect phone number. Please provide a 10-digit mobile number.");
        }
        user.setMobileNumber(userDTO.getMobileNumber());
        user.setDisplayName(userDTO.getDisplayName());
        user.setEmailId(userDTO.getEmailId());
        User updatedUser = (User)this.userRepository.save((Object)user);
        return this.mapToDTO(updatedUser);
    }

    public void deleteUser(int userId) {
        this.userRepository.deleteById((Object)userId);
    }

    public UserDTO getProfileInfo(int userId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        if (user != null) {
            return this.convertToUserDTO(user);
        }
        return null;
    }

    public ResponseOTP cancelAccount(int userId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        if (user != null) {
            user.setStatus(User.UserStatus.INACTIVE);
            user.setDeletedOn(new Date());
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String deletedByUsername = authentication != null && authentication.isAuthenticated() ? authentication.getName() : "unknownUser";
            user.setDeletedBy(Integer.valueOf(userId));
            this.userRepository.save((Object)user);
            ResponseOTP responseOTP = new ResponseOTP();
            responseOTP.setStatus(Integer.valueOf(1));
            responseOTP.setMessage("Account cancelled successfully");
            return responseOTP;
        }
        return null;
    }

    private UserDTO convertToUserDTO(User user) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserKeyId(user.getUserKeyId());
        userDTO.setMobileNumber(user.getMobileNumber());
        userDTO.setDisplayName(user.getDisplayName());
        userDTO.setEmailId(user.getEmailId());
        userDTO.setStatus(user.getStatus());
        String s = user.getImageURL();
        if (s != null && !s.isEmpty()) {
            String filename = s.substring(s.lastIndexOf("/") + 1);
            userDTO.setImageURL("https://dev-api.chataak.in/images/staffprofile/" + filename);
        } else {
            userDTO.setImageURL("https://dev-api.chataak.in/images/profile/default.png");
        }
        return userDTO;
    }

    private User mapToEntity(UserDTO userDTO) {
        User user = (User)this.mapper.map((Object)userDTO, User.class);
        return user;
    }

    private UserDTO mapToDTO(User user) {
        UserDTO userDTO = (UserDTO)this.mapper.map((Object)user, UserDTO.class);
        return userDTO;
    }
}

