/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.CartBillDTO;
import com.chataak.api.dto.CartDTO;
import com.chataak.api.dto.PaymentDto;
import com.chataak.api.dto.ShopCartDTO;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.OrganizationStoreCoupons;
import com.chataak.api.entity.OrganizationStoreEntity;
import com.chataak.api.entity.PaymentTransaction;
import com.chataak.api.entity.ProductImage;
import com.chataak.api.entity.ProductPromotion;
import com.chataak.api.entity.Products;
import com.chataak.api.entity.SessionHistory;
import com.chataak.api.entity.ShoppingCart;
import com.chataak.api.entity.ShoppingCartProducts;
import com.chataak.api.entity.ShoppingCartProductsKey;
import com.chataak.api.entity.User;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OrganizationStoreCouponsRepository;
import com.chataak.api.repo.OrganizationStoreEntityRepository;
import com.chataak.api.repo.OrganizationStoreRepository;
import com.chataak.api.repo.PaymentTransactionRepo;
import com.chataak.api.repo.ProductPromotionRepository;
import com.chataak.api.repo.ProductsRepository;
import com.chataak.api.repo.SessionHistoryRepository;
import com.chataak.api.repo.ShoppingCartProductsRepository;
import com.chataak.api.repo.ShoppingCartRepository;
import com.chataak.api.repo.StockInventoryRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.ShoppingCartProductsService;
import jakarta.persistence.EntityNotFoundException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ShoppingCartProductsServiceImpl
implements ShoppingCartProductsService {
    private static final Logger logger = LoggerFactory.getLogger(ShoppingCartProductsServiceImpl.class);
    @Autowired
    private ShoppingCartRepository shoppingCartRepository;
    @Autowired
    private OrganizationStoreCouponsRepository organizationStoreCouponsRepository;
    @Autowired
    private ProductsRepository productsRepository;
    @Autowired
    private ProductPromotionRepository productPromotionRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PaymentTransactionRepo paymentTransactionRepo;
    @Autowired
    private ShoppingCartProductsRepository cartProductsRepository;
    @Autowired
    private SessionHistoryRepository historyRepository;
    @Autowired
    private OrganizationStoreRepository storesRepository;
    @Autowired
    private StockInventoryRepository stockInventoryRepository;
    @Autowired
    private OrganizationStoreEntityRepository organizationStoreEntityRepository;

    public long countProductsByUserAndStore(Integer userKeyId, Integer storeKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        Date now = new Date();
        Optional cart = this.shoppingCartRepository.findLatestValidCart(userKeyId, storeKeyId, now);
        if (cart == null || cart.isEmpty()) {
            return 0L;
        }
        return this.cartProductsRepository.countByShoppingCart((ShoppingCart)cart.get());
    }

    public CartDTO addProductToCart(Integer userKeyId, Integer storeKeyId, ShopCartDTO produc) {
        ShoppingCart save;
        String username;
        Optional userToken;
        User user;
        ShoppingCartProducts products = new ShoppingCartProducts();
        products.setQuantity(Integer.valueOf(0));
        OrganizationStoreEntity stores = (OrganizationStoreEntity)this.organizationStoreEntityRepository.findByStoreAndProducts(storeKeyId, produc.getProduct().getProductKeyId()).orElseThrow(() -> new ResourceNotFoundException("Sorry, this product is not available in Our Stores."));
        OrganizationStore organizationStore = stores.getStore();
        Products product = stores.getProducts();
        if (stores == null || !stores.getStatus().equals((short)1) || !stores.getProducts().getStatus().equals((short)1)) {
            throw new ResourceNotFoundException("Sorry, this product is not available in Our Stores.");
        }
        products.setDiscountPercentage(BigDecimal.ZERO);
        products.setDiscountAmount(BigDecimal.ZERO);
        products.setCreatedOn(new Date());
        ProductPromotion productPromotion = null;
        if (produc.getPromotion() != null && produc.getPromotion().getPromotionKeyId() != null && !produc.getPromotion().getPromotionKeyId().equals(0) && (productPromotion = (ProductPromotion)this.productPromotionRepository.findById((Object)produc.getPromotion().getPromotionKeyId()).orElseThrow(() -> new ResourceNotFoundException("Promotion not found with id: " + produc.getPromotion().getPromotionKeyId()))).getPromotionPercentage() != null) {
            products.setDiscountPercentage(productPromotion.getPromotionPercentage());
        }
        Integer orgId = organizationStore.getOrganization().getId();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        Integer storeId = organizationStore.getStoreKeyId();
        Long productId = produc.getProduct().getProductKeyId();
        List<Object> list = new ArrayList();
        if (!product.getCategories().isEmpty()) {
            list = product.getCategories().parallelStream().filter(f -> f.getStatus() == 1).map(CategoryManager::getName).toList();
        }
        if (productPromotion == null) {
            Date now = new Date();
            productPromotion = this.productPromotionRepository.findPromotionsByCountryOrStateProductOrCategories(orgId, id, organizationStore.getCountry(), organizationStore.getState(), organizationStore.getCity(), storeId, Short.valueOf((short)1), now, now, productId, list).orElse(null);
        }
        if (!(user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId))).equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        List histories = this.historyRepository.findByUser(user);
        SessionHistory sessionHistory = null;
        if (!histories.isEmpty()) {
            sessionHistory = (SessionHistory)histories.get(histories.size() - 1);
        }
        Optional shoppingCartProduct = (save = this.getOrCreateShoppingCart(userKeyId, storeKeyId, user, organizationStore)) != null ? this.cartProductsRepository.findByCartKeyIdAndProductKeyId(save.getCartKeyId(), product.getProductId()) : Optional.empty();
        Integer quantity = produc.getQuantity();
        if (shoppingCartProduct.isPresent()) {
            quantity = ((ShoppingCartProducts)shoppingCartProduct.get()).getQuantity() + quantity;
        }
        ShoppingCartProductsKey shoppingCartProductsKey = new ShoppingCartProductsKey();
        shoppingCartProductsKey.setShoppingCart(save);
        shoppingCartProductsKey.setProduct(product);
        products.setId(shoppingCartProductsKey);
        products.setShoppingCart(save);
        products.setSessionHistory(sessionHistory);
        products.setSellingUOM(product.getSellingUOM() != null ? product.getSellingUOM().getUnit() : null);
        BigDecimal actualSellingPrice = stores.getSellingPrice();
        products.setInStock(true);
        Integer availableQty = stores.getQuantity();
        if (availableQty == null || availableQty.equals(0)) {
            String errorMessage = "out of stock";
            CartDTO cartDTO = new CartDTO();
            cartDTO.setStatus(Integer.valueOf(0));
            cartDTO.setMessage("out of stock");
            cartDTO.setCartKeyId(save.getCartKeyId());
            return cartDTO;
        }
        if (quantity == 0 || quantity == null) {
            quantity = 1;
        }
        if (quantity > availableQty) {
            String errorMessage = "out of stock";
            CartDTO cartDTO = new CartDTO();
            cartDTO.setStatus(Integer.valueOf(0));
            cartDTO.setMessage("out of stock");
            cartDTO.setCartKeyId(save.getCartKeyId());
            return cartDTO;
        }
        short s = 1;
        if (!product.getStatus().equals(s)) {
            CartDTO cartDTO = new CartDTO();
            cartDTO.setStatus(Integer.valueOf(0));
            cartDTO.setMessage("out of stock");
            cartDTO.setCartKeyId(save.getCartKeyId());
            return cartDTO;
        }
        BigDecimal quantityDecimal = BigDecimal.ZERO;
        quantityDecimal = BigDecimal.valueOf(quantity.intValue());
        if (productPromotion != null) {
            if (productPromotion.getProduct().equals(product)) {
                products.setPromotion(productPromotion);
                if (productPromotion.getPromotionPercentage() != null) {
                    products.setDiscountPercentage(productPromotion.getPromotionPercentage());
                }
            } else {
                products.setPromotion(null);
            }
        } else {
            products.setPromotion(null);
        }
        if (actualSellingPrice == null) {
            throw new RuntimeException("selling price should not be null");
        }
        products.setOrignalPrice(actualSellingPrice.setScale(2, RoundingMode.HALF_UP));
        BigDecimal discount = products.getOrignalPrice().multiply(products.getDiscountPercentage().divide(new BigDecimal("100")));
        logger.info("discount:" + discount);
        BigDecimal scale = discount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal zero = new BigDecimal("0");
        BigDecimal zero1 = new BigDecimal("0.0");
        BigDecimal zero2 = new BigDecimal("0.00");
        products.setPromoDiscountAmount(zero2);
        if (!(scale.equals(zero) || scale.equals(zero1) || scale.equals(zero2))) {
            products.setPromoDiscountAmount(scale);
        } else if (productPromotion != null && productPromotion.getPromotionAmount() != null) {
            discount = productPromotion.getPromotionAmount();
            products.setDiscountAmount(productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP));
            products.setPromoDiscountAmount(productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal actualSellingPriceAndDiscount = products.getOrignalPrice().subtract(discount);
        logger.info("sellingPrice:" + actualSellingPriceAndDiscount);
        if (quantity != null) {
            products.setActualSellingPrice(actualSellingPriceAndDiscount.setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal displayAmount = actualSellingPriceAndDiscount.multiply(quantityDecimal);
        products.setDisplayAmount(displayAmount.setScale(2, RoundingMode.HALF_UP));
        logger.info("setDisplayAmount" + products.getDisplayAmount());
        products.setProduct(product);
        products = this.taxCalculator(products, stores);
        products.setQuantity(quantity);
        products.setPromotion(productPromotion);
        ShoppingCartProducts save1 = (ShoppingCartProducts)this.cartProductsRepository.save((Object)products);
        CartDTO cartDTO = new CartDTO();
        cartDTO.setStatus(Integer.valueOf(1));
        cartDTO.setMessage("Successfully added to cart");
        cartDTO.setCartKeyId(save1.getShoppingCart().getCartKeyId());
        return cartDTO;
    }

    private ShoppingCart getOrCreateShoppingCart(Integer userKeyId, Integer storeKeyId, User user, OrganizationStore organizationStore) {
        ShoppingCart cart = this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null);
        if (cart != null) {
            return cart;
        }
        ShoppingCart shoppingCart = new ShoppingCart();
        shoppingCart.setCartCreatedOn(new Date());
        LocalDate localDate = LocalDate.now().plusDays(30L);
        Instant instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        shoppingCart.setCartValidTill(date);
        shoppingCart.setCreatedOn(new Date());
        shoppingCart.setCreatedBy(userKeyId);
        BigDecimal bigDecimal = new BigDecimal("0.00");
        shoppingCart.setCouponAmount(bigDecimal);
        Short aShort = 1;
        shoppingCart.setStatus(aShort.shortValue());
        shoppingCart.setUser(user);
        shoppingCart.setStore(organizationStore);
        return (ShoppingCart)this.shoppingCartRepository.save((Object)shoppingCart);
    }

    public void removeCartProducts(Integer storeKeyId, Integer userKeyId, Long productKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        Products product = (Products)this.productsRepository.findById((Object)productKeyId).orElseThrow(() -> new ResourceNotFoundException("Product not found with id: " + productKeyId));
        ShoppingCart cart = this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null);
        if (cart == null) {
            throw new EntityNotFoundException("Shopping cart is empty or invalid");
        }
        ShoppingCartProducts shoppingCartProduct = (ShoppingCartProducts)this.cartProductsRepository.findByShoppingCartAndProduct(cart, product).orElseThrow(() -> new ResourceNotFoundException("Shopping Cart Product not found"));
        this.cartProductsRepository.delete((Object)shoppingCartProduct);
    }

    public String updateCartProducts(Integer storeKeyId, Integer userKeyId, ShopCartDTO products) {
        ShoppingCart cart;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        OrganizationStoreEntity stores = (OrganizationStoreEntity)this.organizationStoreEntityRepository.findByStoreAndProducts(storeKeyId, products.getProduct().getProductKeyId()).orElseThrow(() -> new ResourceNotFoundException("Sorry, this product is not available in Our Stores."));
        OrganizationStore organizationStore = stores.getStore();
        Products product = stores.getProducts();
        String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        Optional userToken = this.userRepository.findByMobileNumber(username);
        if (!user.equals(userToken.get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        List histories = this.historyRepository.findByUser(user);
        SessionHistory sessionHistory = null;
        if (!histories.isEmpty()) {
            sessionHistory = (SessionHistory)histories.get(histories.size() - 1);
        }
        if ((cart = (ShoppingCart)this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null)) == null) {
            throw new EntityNotFoundException("Shopping cart is empty or invalid");
        }
        short s = 1;
        if (!product.getStatus().equals(s)) {
            String errorMessage = "out of stock";
            return "out of stock";
        }
        ShoppingCartProducts shoppingCartProduct = (ShoppingCartProducts)this.cartProductsRepository.findByShoppingCartAndProduct(cart, product).orElseThrow(() -> new ResourceNotFoundException("Shopping Cart Product not found"));
        BigDecimal actualSellingPrice = stores.getSellingPrice();
        Integer quantity = products.getQuantity();
        Integer availableQty = stores.getQuantity();
        if (quantity > availableQty) {
            String errorMessage = "out of stock";
            return "out of stock";
        }
        if (quantity.equals(0)) {
            this.cartProductsRepository.delete((Object)shoppingCartProduct);
            return "Successfully updated in the cart";
        }
        if (availableQty == null || availableQty.equals(0)) {
            String errorMessage = "out of stock";
            throw new ResourceNotFoundException(errorMessage);
        }
        shoppingCartProduct.setDiscountPercentage(BigDecimal.ZERO);
        shoppingCartProduct.setDiscountAmount(BigDecimal.ZERO);
        shoppingCartProduct.setQuantity(quantity);
        shoppingCartProduct.setInStock(true);
        ProductPromotion productPromotion = null;
        if (products.getPromotion() != null && products.getPromotion().getPromotionKeyId() != null && !products.getPromotion().getPromotionKeyId().equals(0) && (productPromotion = (ProductPromotion)this.productPromotionRepository.findById((Object)products.getPromotion().getPromotionKeyId()).orElseThrow(() -> new ResourceNotFoundException("Promotion not found with id: " + products.getPromotion().getPromotionKeyId()))).getPromotionPercentage() != null) {
            shoppingCartProduct.setDiscountPercentage(productPromotion.getPromotionPercentage());
        }
        Integer orgId = cart.getStore().getOrganization().getId();
        Integer id = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        Integer storeId = cart.getStore().getStoreKeyId();
        Long productId = products.getProduct().getProductKeyId();
        List<Object> list = new ArrayList();
        if (!product.getCategories().isEmpty()) {
            list = product.getCategories().parallelStream().filter(f -> f.getStatus() == 1).map(CategoryManager::getName).toList();
        }
        if (productPromotion == null) {
            Date now = new Date();
            productPromotion = this.productPromotionRepository.findPromotionsByCountryOrStateProductOrCategories(orgId, id, organizationStore.getCountry(), organizationStore.getState(), organizationStore.getCity(), storeId, Short.valueOf((short)1), now, now, productId, list).orElse(null);
        }
        if (productPromotion != null && productPromotion.getPromotionPercentage() != null) {
            shoppingCartProduct.setPromotion(productPromotion);
            shoppingCartProduct.setDiscountPercentage(productPromotion.getPromotionPercentage());
        }
        if (productPromotion != null) {
            if (productPromotion.getProduct().equals(product)) {
                shoppingCartProduct.setPromotion(productPromotion);
                if (productPromotion.getPromotionPercentage() != null) {
                    shoppingCartProduct.setDiscountPercentage(productPromotion.getPromotionPercentage());
                }
            } else {
                shoppingCartProduct.setPromotion(null);
            }
        } else {
            shoppingCartProduct.setPromotion(null);
        }
        shoppingCartProduct.setQuantity(products.getQuantity());
        BigDecimal quantityDecimal = BigDecimal.ZERO;
        quantityDecimal = BigDecimal.valueOf(quantity.intValue());
        if (actualSellingPrice == null) {
            throw new RuntimeException("selling price should not be null");
        }
        shoppingCartProduct.setOrignalPrice(actualSellingPrice.setScale(2, RoundingMode.HALF_UP));
        BigDecimal discount = shoppingCartProduct.getOrignalPrice().multiply(shoppingCartProduct.getDiscountPercentage().divide(new BigDecimal("100")));
        logger.info("discount:" + discount);
        BigDecimal zero = new BigDecimal("0");
        BigDecimal zero1 = new BigDecimal("0.0");
        BigDecimal zero2 = new BigDecimal("0.00");
        BigDecimal scale = discount.setScale(2, RoundingMode.HALF_UP);
        if (!(scale.equals(zero) || scale.equals(zero1) || scale.equals(zero2))) {
            shoppingCartProduct.setPromoDiscountAmount(scale);
        } else if (productPromotion != null && productPromotion.getPromotionAmount() != null) {
            discount = productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP);
            shoppingCartProduct.setDiscountAmount(productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP));
            shoppingCartProduct.setPromoDiscountAmount(productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal actualSellingPriceAndDiscount = shoppingCartProduct.getOrignalPrice().subtract(discount);
        logger.info("sellingPrice:" + actualSellingPriceAndDiscount);
        if (quantity != null) {
            shoppingCartProduct.setActualSellingPrice(actualSellingPriceAndDiscount.setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal displayAmount = actualSellingPriceAndDiscount.multiply(quantityDecimal);
        shoppingCartProduct.setDisplayAmount(displayAmount.setScale(2, RoundingMode.HALF_UP));
        shoppingCartProduct.setSessionHistory(sessionHistory);
        shoppingCartProduct = this.taxCalculator(shoppingCartProduct, stores);
        shoppingCartProduct.setPromotion(productPromotion);
        this.cartProductsRepository.save((Object)shoppingCartProduct);
        return "Successfully updated in the cart";
    }

    public boolean recalculateCart(Integer userKeyId, Integer storeKeyId) {
        List shoppingCartProducts;
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        List carts = this.shoppingCartRepository.findByUser_UserKeyIdAndStore_StoreKeyId(userKeyId, storeKeyId);
        ShoppingCart cart = null;
        if (!carts.isEmpty() && ((ShoppingCart)carts.get(carts.size() - 1)).getCartValidTill().after(new Date()) && ((ShoppingCart)carts.get(carts.size() - 1)).getCartCompletedOn() == null) {
            cart = (ShoppingCart)carts.get(carts.size() - 1);
        }
        boolean isCartChange = false;
        if (cart != null && !(shoppingCartProducts = this.cartProductsRepository.findByShoppingCart(cart)).isEmpty()) {
            for (ShoppingCartProducts shoppingCartProduct : shoppingCartProducts) {
                Optional productsOptional = this.productsRepository.findById((Object)shoppingCartProduct.getProduct().getProductId());
                if (productsOptional.isPresent()) {
                    Products product = (Products)productsOptional.get();
                    OrganizationStoreEntity stores = (OrganizationStoreEntity)this.organizationStoreEntityRepository.findByStoreAndProducts(shoppingCartProduct.getShoppingCart().getStore().getStoreKeyId(), product.getProductId()).orElseThrow(() -> new ResourceNotFoundException("Sorry, this product is not available in Our Stores."));
                    ProductPromotion productPromotion = shoppingCartProduct.getPromotion();
                    BigDecimal taxableAmount = shoppingCartProduct.getTaxableAmount();
                    BigDecimal cartProductTotalAmount = shoppingCartProduct.getTotalAmount();
                    BigDecimal actualSellingPrice = stores.getSellingPrice();
                    Integer quantity = shoppingCartProduct.getQuantity();
                    Integer availableQty = stores.getQuantity();
                    boolean promotionValidTill = true;
                    short s = 1;
                    if (product.getStatus() == s) {
                        if (productPromotion != null && (productPromotion.getValidTill().before(new Date()) || !productPromotion.getStatus().equals((short)1))) {
                            promotionValidTill = false;
                        }
                        boolean inStock = shoppingCartProduct.isInStock();
                        if (quantity > availableQty && inStock || availableQty != 0 && !inStock || !stores.getSellingPrice().equals(shoppingCartProduct.getOrignalPrice()) || !promotionValidTill || productPromotion != null && !productPromotion.equals((Object)shoppingCartProduct.getPromotion()) || !stores.getCgst().equals(shoppingCartProduct.getCgstRate()) || !stores.getSgst().equals(shoppingCartProduct.getSgstRate())) {
                            if (availableQty != 0 && quantity > availableQty) {
                                quantity = availableQty;
                                isCartChange = true;
                            }
                            shoppingCartProduct.setInStock(true);
                            shoppingCartProduct.setPromotion(productPromotion);
                            shoppingCartProduct.setOrignalPrice(stores.getSellingPrice());
                            shoppingCartProduct.setCgstRate(stores.getCgst());
                            shoppingCartProduct.setSgstRate(stores.getSgst());
                            Integer orgId = cart.getStore().getOrganization().getId();
                            Integer id = cart.getStore().getMerchantId() != null ? cart.getStore().getMerchantId().getId() : cart.getStore().getOrganization().getId();
                            Integer storeId = cart.getStore().getStoreKeyId();
                            Long productId = product.getProductId();
                            List<Object> list = new ArrayList();
                            if (!product.getCategories().isEmpty()) {
                                list = product.getCategories().parallelStream().filter(f -> f.getStatus() == 1).map(CategoryManager::getName).toList();
                            }
                            if (productPromotion == null) {
                                Date now = new Date();
                                productPromotion = this.productPromotionRepository.findPromotionsByCountryOrStateProductOrCategories(orgId, id, cart.getStore().getCountry(), cart.getStore().getState(), cart.getStore().getCity(), storeId, Short.valueOf((short)1), now, now, productId, list).orElse(null);
                            }
                            if (productPromotion != null) {
                                if (productPromotion.getProduct().equals(product)) {
                                    shoppingCartProduct.setPromotion(productPromotion);
                                    shoppingCartProduct.setDiscountPercentage(productPromotion.getPromotionPercentage());
                                } else {
                                    shoppingCartProduct.setPromotion(null);
                                }
                            } else {
                                shoppingCartProduct.setPromotion(null);
                            }
                            shoppingCartProduct.setQuantity(quantity);
                            BigDecimal quantityDecimal = BigDecimal.ZERO;
                            quantityDecimal = BigDecimal.valueOf(quantity.intValue());
                            if (actualSellingPrice == null) {
                                throw new RuntimeException("selling price should not be null");
                            }
                            shoppingCartProduct.setOrignalPrice(actualSellingPrice.setScale(2, RoundingMode.HALF_UP));
                            BigDecimal discount = shoppingCartProduct.getOrignalPrice().multiply(shoppingCartProduct.getDiscountPercentage().divide(new BigDecimal("100")));
                            logger.info("discount:" + discount);
                            BigDecimal zero = new BigDecimal("0");
                            BigDecimal zero1 = new BigDecimal("0.0");
                            BigDecimal zero2 = new BigDecimal("0.00");
                            BigDecimal scale = discount.setScale(2, RoundingMode.HALF_UP);
                            if (!(scale.equals(zero) || scale.equals(zero1) || scale.equals(zero2))) {
                                shoppingCartProduct.setPromoDiscountAmount(scale);
                            } else if (productPromotion != null && productPromotion.getPromotionAmount() != null) {
                                discount = productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP);
                                shoppingCartProduct.setPromoDiscountAmount(productPromotion.getPromotionAmount());
                                shoppingCartProduct.setDiscountAmount(productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP));
                            }
                            BigDecimal actualSellingPriceAndDiscount = shoppingCartProduct.getOrignalPrice().subtract(discount);
                            logger.info("sellingPrice:" + actualSellingPriceAndDiscount);
                            if (quantity != null) {
                                shoppingCartProduct.setActualSellingPrice(actualSellingPriceAndDiscount.setScale(2, RoundingMode.HALF_UP));
                            }
                            BigDecimal displayAmount = actualSellingPriceAndDiscount.multiply(quantityDecimal);
                            shoppingCartProduct.setDisplayAmount(displayAmount.setScale(2, RoundingMode.HALF_UP));
                            shoppingCartProduct = this.taxCalculator(shoppingCartProduct, stores);
                        } else {
                            isCartChange = false;
                        }
                        if (!promotionValidTill) {
                            isCartChange = true;
                        }
                        if (inStock != shoppingCartProduct.isInStock()) {
                            isCartChange = true;
                        }
                    } else {
                        isCartChange = true;
                        shoppingCartProduct.setInStock(false);
                    }
                    if (!taxableAmount.equals(shoppingCartProduct.getTaxableAmount())) {
                        isCartChange = true;
                    }
                    if (!cartProductTotalAmount.equals(shoppingCartProduct.getTotalAmount())) {
                        isCartChange = true;
                    }
                    if (!actualSellingPrice.equals(shoppingCartProduct.getOrignalPrice())) {
                        isCartChange = true;
                    }
                } else {
                    isCartChange = true;
                    shoppingCartProduct.setInStock(false);
                }
                this.cartProductsRepository.save((Object)shoppingCartProduct);
            }
        }
        return isCartChange;
    }

    private ShoppingCartProducts taxCalculator(ShoppingCartProducts shoppingCartProduct, OrganizationStoreEntity product) {
        shoppingCartProduct.setSpInclusiveTax(product.getProducts().getSpInclusiveTax());
        shoppingCartProduct.setCgstRate(product.getCgst());
        shoppingCartProduct.setSgstRate(product.getSgst());
        if (!product.getProducts().getSpInclusiveTax().booleanValue()) {
            BigDecimal amountExcludingTax = shoppingCartProduct.getDisplayAmount();
            shoppingCartProduct.setTaxableAmount(amountExcludingTax.setScale(2, RoundingMode.HALF_UP));
            BigDecimal cgst = BigDecimal.ZERO;
            BigDecimal sgst = BigDecimal.ZERO;
            BigDecimal igst = BigDecimal.ZERO;
            BigDecimal tax2 = BigDecimal.ZERO;
            if (product.getCgst() != null) {
                cgst = BigDecimal.valueOf(product.getCgst() * amountExcludingTax.doubleValue() / 100.0);
            }
            if (product.getSgst() != null) {
                sgst = BigDecimal.valueOf(product.getSgst() * amountExcludingTax.doubleValue() / 100.0);
            }
            BigDecimal totalAmount = cgst.add(sgst).add(amountExcludingTax);
            BigDecimal cgstAmountScale = cgst.setScale(2, RoundingMode.HALF_UP);
            BigDecimal sgstAmountScale = sgst.setScale(2, RoundingMode.HALF_UP);
            shoppingCartProduct.setCgstAmount(Double.valueOf(cgstAmountScale.doubleValue()));
            shoppingCartProduct.setSgstAmount(Double.valueOf(sgstAmountScale.doubleValue()));
            shoppingCartProduct.setTotalAmount(totalAmount.setScale(2, RoundingMode.HALF_UP));
        } else {
            BigDecimal cgst = BigDecimal.ZERO;
            BigDecimal sgst = BigDecimal.ZERO;
            BigDecimal igst = BigDecimal.ZERO;
            BigDecimal tax2 = BigDecimal.ZERO;
            if (product.getCgst() != null) {
                cgst = BigDecimal.valueOf(product.getCgst() / 100.0);
            }
            if (product.getSgst() != null) {
                sgst = BigDecimal.valueOf(product.getSgst() / 100.0);
                logger.info("sgst:" + sgst);
            }
            BigDecimal one = new BigDecimal("1.00");
            BigDecimal added = cgst.add(sgst).add(igst).add(tax2);
            logger.info("added:" + added);
            BigDecimal displayAmountScale = shoppingCartProduct.getDisplayAmount().setScale(2, RoundingMode.HALF_UP);
            logger.info("added:" + added);
            BigDecimal added1 = added.add(BigDecimal.ONE);
            BigDecimal amountExcludingTax = displayAmountScale.divide(added1, 2, RoundingMode.HALF_UP);
            logger.info("TaxableAmount:" + amountExcludingTax);
            shoppingCartProduct.setTaxableAmount(amountExcludingTax.setScale(2, RoundingMode.HALF_UP));
            shoppingCartProduct.setTotalAmount(shoppingCartProduct.getDisplayAmount().setScale(2, RoundingMode.HALF_UP));
            BigDecimal cgstAmount = BigDecimal.ZERO;
            BigDecimal sgstAmount = BigDecimal.ZERO;
            BigDecimal igstAmount = BigDecimal.ZERO;
            BigDecimal tax2Amount = BigDecimal.ZERO;
            if (product.getCgst() != null) {
                cgstAmount = BigDecimal.valueOf(product.getCgst() * amountExcludingTax.doubleValue() / 100.0);
            }
            if (product.getSgst() != null) {
                sgstAmount = BigDecimal.valueOf(product.getSgst() * amountExcludingTax.doubleValue() / 100.0);
            }
            BigDecimal cgstAmountScale = cgstAmount.setScale(2, RoundingMode.HALF_UP);
            BigDecimal sgstAmountScale = sgstAmount.setScale(2, RoundingMode.HALF_UP);
            BigDecimal igstAmountScale = igstAmount.setScale(2, RoundingMode.HALF_UP);
            BigDecimal tax2AmountScale = tax2Amount.setScale(2, RoundingMode.HALF_UP);
            shoppingCartProduct.setCgstAmount(Double.valueOf(cgstAmountScale.doubleValue()));
            shoppingCartProduct.setSgstAmount(Double.valueOf(sgstAmountScale.doubleValue()));
            shoppingCartProduct.setIgstAmount(Double.valueOf(igstAmountScale.doubleValue()));
            shoppingCartProduct.setTax2Amount(Double.valueOf(tax2AmountScale.doubleValue()));
        }
        return shoppingCartProduct;
    }

    public List<Map<String, Object>> getShoppingCart(Integer userKeyId, Integer storeKeyId) {
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        ShoppingCart cart = this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null);
        if (cart == null) {
            return mapList;
        }
        List shoppingCartProducts = this.cartProductsRepository.findByShoppingCart(cart).parallelStream().sorted(Comparator.comparing(ShoppingCartProducts::getCreatedOn)).collect(Collectors.toList());
        if (shoppingCartProducts == null || shoppingCartProducts.isEmpty()) {
            cart.setCouponAmount(new BigDecimal(0));
            cart.setCoupons(null);
            this.shoppingCartRepository.save((Object)cart);
            return mapList;
        }
        int size = shoppingCartProducts.size();
        Object displayNameCategory1 = null;
        Object displayNameCategory2 = null;
        Object displayNameCategory3 = null;
        for (ShoppingCartProducts products : shoppingCartProducts) {
            int i;
            OrganizationStoreEntity stores = (OrganizationStoreEntity)this.organizationStoreEntityRepository.findByStoreAndProducts(products.getShoppingCart().getStore().getStoreKeyId(), products.getProduct().getProductId()).orElseThrow(() -> new ResourceNotFoundException("Sorry, this product is not available in Our Stores."));
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            map.put("quantity", stores.getQuantity());
            map.put("isUserAdded", true);
            map.put("userAddedQty", products.getQuantity());
            map.put("productKeyId", products.getProduct().getProductId());
            map.put("productName", products.getProduct().getProductName());
            List productImages = products.getProduct().getProductImages();
            String imageURL1 = productImages != null && !productImages.isEmpty() ? ((ProductImage)productImages.get(0)).getImageUrl() : "https://dev-api.chataak.in/images/profile/no_image_available.png";
            if (imageURL1 != null && !imageURL1.isEmpty()) {
                String filename = imageURL1.substring(imageURL1.lastIndexOf("/") + 1);
                map.put("imageURL1", "https://dev-api.chataak.in/images/thumbnail/" + filename);
            } else {
                map.put("imageURL1", imageURL1);
            }
            map.put("productDescription", products.getProduct().getProductDescription());
            map.put("availableQty", stores.getQuantity());
            map.put("isInStock", products.isInStock());
            if (products.getPromotion() != null) {
                map.put("promotionKeyId", products.getPromotion().getPromotionId());
            } else {
                map.put("promotionKeyId", 0);
            }
            if (products.getDiscountPercentage() != null) {
                map.put("discountPercentage", products.getDiscountPercentage());
            } else {
                map.put("discountPercentage", 0);
            }
            if (products.getDiscountAmount() != null) {
                map.put("discountAmount", products.getDiscountAmount());
            } else {
                map.put("discountAmount", 0);
            }
            map.put("originalPrice", products.getOrignalPrice().setScale(2, RoundingMode.HALF_UP));
            map.put("sellingPrice", products.getActualSellingPrice().setScale(2, RoundingMode.HALF_UP));
            map.put("totalAmount", products.getDisplayAmount().setScale(2, RoundingMode.HALF_UP));
            map.put("cartKeyId", products.getShoppingCart().getCartKeyId());
            List categories = products.getProduct().getCategories();
            int category = 0;
            if (products.getProduct().getBrand() != null) {
                map.put("category" + (category + 1), products.getProduct().getBrand().getName());
                map.put("displayNameCategory" + (category + 1), "Brand");
                ++category;
            }
            for (i = 0; i < categories.size() && category < 3; ++i, ++category) {
                if (((CategoryManager)categories.get(i)).getName() == null || ((CategoryManager)categories.get(i)).getLabel() == null) continue;
                map.put("category" + (category + 1), ((CategoryManager)categories.get(i)).getName());
                map.put("displayNameCategory" + (category + 1), ((CategoryManager)categories.get(i)).getLabel());
            }
            for (i = category; i < 3; ++i) {
                map.put("category" + (i + 1), null);
                map.put("displayNameCategory" + (i + 1), null);
            }
            mapList.add(map);
        }
        return mapList;
    }

    public Map<String, Object> getShoppingCartSummary(Integer userKeyId, Integer storeKeyId) {
        List shoppingCartProducts;
        String username;
        Optional userToken;
        User user = (User)this.userRepository.findById((Object)userKeyId).orElseThrow(() -> new ResourceNotFoundException("User not found with id: " + userKeyId));
        if (!user.equals((userToken = this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername())).get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        ShoppingCart cart = this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null);
        HashMap<String, Object> cartSummary = new HashMap<String, Object>();
        if (cart == null) {
            cartSummary.put("totalCartValue", 0);
            cartSummary.put("itemCount", 0);
            return cartSummary;
        }
        BigDecimal couponAmount = cart.getCouponAmount();
        if (couponAmount == null) {
            BigDecimal bigDecimal;
            couponAmount = bigDecimal = new BigDecimal("0.00");
        }
        if ((shoppingCartProducts = this.cartProductsRepository.findByShoppingCart(cart)) == null || shoppingCartProducts.isEmpty()) {
            cartSummary.put("totalCartValue", 0);
            cartSummary.put("itemCount", 0);
            return cartSummary;
        }
        BigDecimal totalCartValue = BigDecimal.ZERO;
        int itemCount = shoppingCartProducts.size();
        for (ShoppingCartProducts products : shoppingCartProducts) {
            if (!products.isInStock()) continue;
            BigDecimal totalAmount = products.getTotalAmount();
            Integer quantity = products.getQuantity();
            if (totalAmount == null || quantity == null) continue;
            totalCartValue = totalCartValue.add(totalAmount);
        }
        BigDecimal scale = totalCartValue.subtract(couponAmount).setScale(2, RoundingMode.HALF_UP);
        cartSummary.put("totalCartValue", scale);
        cartSummary.put("itemCount", itemCount);
        return cartSummary;
    }

    private List<Map<String, Object>> getCartDetails(List<ShoppingCartProducts> shoppingCartProducts) {
        ArrayList<Map<String, Object>> cartDetails = new ArrayList<Map<String, Object>>();
        for (ShoppingCartProducts products : shoppingCartProducts) {
            HashMap cartDetail = new HashMap();
            cartDetails.add(cartDetail);
        }
        return cartDetails;
    }

    public PaymentDto processPayment(int cartKeyId, PaymentDto paymentDto) {
        BigDecimal percentage;
        BigDecimal amount;
        BigDecimal bigDecimal;
        List shoppingCartProducts;
        ShoppingCart shoppingCart = (ShoppingCart)this.shoppingCartRepository.findById((Object)cartKeyId).orElseThrow(() -> new ResourceNotFoundException("cart not found" + cartKeyId));
        String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        Optional userToken = this.userRepository.findByMobileNumber(username);
        if (!shoppingCart.getUser().equals(userToken.get())) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        OrganizationStoreCoupons coupons = null;
        if (shoppingCart.getCoupons() != null) {
            coupons = shoppingCart.getCoupons();
        }
        if ((shoppingCartProducts = this.cartProductsRepository.findByShoppingCart(shoppingCart)) == null || shoppingCartProducts.isEmpty()) {
            throw new EntityNotFoundException("Shopping cart products are empty");
        }
        HashMap cartSummary = new HashMap();
        BigDecimal totalCartValue = BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ZERO;
        for (ShoppingCartProducts products : shoppingCartProducts) {
            BigDecimal totalAmount = products.getTotalAmount();
            Integer quantity = products.getQuantity();
            totalCartValue = totalCartValue.add(totalAmount);
            discount = discount.add(products.getDiscountAmount());
        }
        logger.info("totalCartValue-" + totalCartValue);
        BigDecimal totalCoupon = bigDecimal = new BigDecimal("0.00");
        BigDecimal couponPercentage = bigDecimal;
        BigDecimal couponAmount = bigDecimal;
        if (coupons != null && coupons.isBillAmountBased() && totalCartValue.compareTo(coupons.getBillAmountFrom()) >= 0 && totalCartValue.compareTo(coupons.getBillAmountTo()) <= 0) {
            amount = coupons.getCouponAmount();
            percentage = coupons.getCouponPercentage();
            if (percentage != null) {
                couponPercentage = percentage;
                logger.info("couponPercentage-" + couponPercentage);
            }
            if (amount != null) {
                couponAmount = amount;
                logger.info("couponAmount-" + couponAmount);
            }
        }
        if (coupons != null && !coupons.isBillAmountBased()) {
            amount = coupons.getCouponAmount();
            percentage = coupons.getCouponPercentage();
            if (percentage != null) {
                couponPercentage = percentage;
                logger.info("couponPercentage-" + couponPercentage);
            }
            if (amount != null) {
                couponAmount = amount;
                logger.info("couponAmount 2-" + couponAmount);
            }
        }
        if (!couponAmount.equals(bigDecimal)) {
            logger.info("totalCoupon -");
            totalCoupon = couponAmount;
            logger.info("totalCoupon -" + totalCoupon);
        } else {
            logger.info("totalCoupon 2-");
            totalCoupon = totalCartValue.multiply(couponPercentage.divide(new BigDecimal("100")));
            logger.info("totalCoupon 2-" + totalCoupon);
        }
        if (totalCoupon.setScale(2, RoundingMode.HALF_UP).equals(bigDecimal) || totalCoupon.equals(BigDecimal.ZERO)) {
            coupons = null;
        }
        System.out.println(totalCoupon);
        shoppingCart.setCoupons(coupons);
        shoppingCart.setCouponAmount(totalCoupon.setScale(2, RoundingMode.HALF_UP));
        PaymentTransaction orderPayment = new PaymentTransaction();
        orderPayment.setCreatedAt(LocalDateTime.now());
        orderPayment.setTransactionDate(LocalDateTime.now());
        orderPayment.setStatus(Short.valueOf((short)1));
        orderPayment.setStore(shoppingCart.getStore());
        orderPayment.setUser((User)userToken.get());
        orderPayment.setOrderPaymentId("1");
        orderPayment.setMethodType(paymentDto.getPaymentType());
        if (shoppingCart.getCouponAmount() != null) {
            couponAmount = shoppingCart.getCouponAmount();
        }
        orderPayment.setAmount(totalCartValue.subtract(shoppingCart.getCouponAmount()).setScale(2, RoundingMode.HALF_UP));
        orderPayment.setPaymentId(ShoppingCartProductsServiceImpl.generateRandomString((int)13));
        orderPayment.setOrganization(shoppingCart.getStore().isMerchantIn() ? shoppingCart.getStore().getMerchantId() : shoppingCart.getStore().getOrganization());
        shoppingCart.setPaymentTransaction((PaymentTransaction)this.paymentTransactionRepo.save((Object)orderPayment));
        this.shoppingCartRepository.save((Object)shoppingCart);
        paymentDto.setCartKeyId(Integer.valueOf(cartKeyId));
        paymentDto.setStatus(Integer.valueOf(1));
        paymentDto.setMessage("Payment Successfull");
        return paymentDto;
    }

    public CartBillDTO getBillOfCart(Integer cartKeyId) {
        List cartProducts;
        String username;
        User currentUser;
        ShoppingCart cart = (ShoppingCart)this.shoppingCartRepository.findById((Object)cartKeyId).orElseThrow(() -> new ResourceNotFoundException("Shopping Cart not found"));
        User cartUser = cart.getUser();
        if (!cartUser.equals((Object)(currentUser = (User)this.userRepository.findByMobileNumber(username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername()).orElseThrow(() -> new ResourceNotFoundException("User not found"))))) {
            throw new BadCredentialsException("Access denied: The provided credentials do not match the user associated with this token.");
        }
        OrganizationStoreCoupons coupons = cart.getCoupons();
        Date now = new Date();
        if (coupons != null && (coupons.isDeleted() || coupons.getCouponStatus() == 0 || coupons.getCouponEndDate().before(now))) {
            coupons = null;
        }
        if ((cartProducts = this.cartProductsRepository.findByShoppingCart(cart)) == null || cartProducts.isEmpty()) {
            throw new EntityNotFoundException("Shopping cart products are empty");
        }
        BigDecimal totalCartValue = BigDecimal.ZERO;
        BigDecimal taxableAmount = BigDecimal.ZERO;
        BigDecimal tax1Value = BigDecimal.ZERO;
        BigDecimal tax2Value = BigDecimal.ZERO;
        int itemCount = 0;
        for (ShoppingCartProducts product : cartProducts) {
            if (!product.isInStock()) continue;
            totalCartValue = totalCartValue.add(product.getTotalAmount());
            itemCount += product.getQuantity().intValue();
            taxableAmount = taxableAmount.add(product.getTaxableAmount());
            tax1Value = tax1Value.add(BigDecimal.valueOf(product.getSgstAmount()));
            tax2Value = tax2Value.add(BigDecimal.valueOf(product.getCgstAmount()));
        }
        taxableAmount = taxableAmount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal couponDiscount = BigDecimal.ZERO;
        BigDecimal couponPercentage = BigDecimal.ZERO;
        BigDecimal couponAmount = BigDecimal.ZERO;
        if (coupons != null) {
            couponPercentage = coupons.getCouponPercentage() != null ? coupons.getCouponPercentage() : BigDecimal.ZERO;
            BigDecimal bigDecimal = couponAmount = coupons.getCouponAmount() != null ? coupons.getCouponAmount() : BigDecimal.ZERO;
            if (coupons.isBillAmountBased() && (totalCartValue.compareTo(coupons.getBillAmountFrom()) < 0 || totalCartValue.compareTo(coupons.getBillAmountTo()) > 0)) {
                coupons = null;
            }
            if (coupons != null) {
                if (couponAmount.compareTo(BigDecimal.ZERO) > 0) {
                    couponDiscount = couponAmount;
                } else {
                    couponDiscount = totalCartValue.multiply(couponPercentage.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
                    couponDiscount = couponDiscount.setScale(2, RoundingMode.HALF_UP);
                }
            }
        }
        if (couponDiscount.compareTo(BigDecimal.ZERO) == 0) {
            coupons = null;
        }
        cart.setCoupons(coupons);
        cart.setCouponAmount(couponDiscount.setScale(2, RoundingMode.HALF_UP));
        ShoppingCart savedCart = (ShoppingCart)this.shoppingCartRepository.save((Object)cart);
        CartBillDTO billDTO = new CartBillDTO();
        billDTO.setBill(totalCartValue.setScale(2, RoundingMode.HALF_UP));
        billDTO.setTaxableAmount(taxableAmount);
        if (savedCart.getCoupons() != null) {
            billDTO.setCouponName(savedCart.getCoupons().getCouponName());
            billDTO.setIsCouponApplied(Boolean.valueOf(true));
        } else {
            billDTO.setCouponName(null);
            billDTO.setIsCouponApplied(Boolean.valueOf(false));
        }
        billDTO.setCouponOffer(savedCart.getCouponAmount());
        billDTO.setCouponOffAmount(couponAmount);
        billDTO.setCouponOffPercentage(couponPercentage);
        billDTO.setPayAmount(totalCartValue.subtract(savedCart.getCouponAmount()).setScale(2, RoundingMode.HALF_UP));
        BigDecimal sgstScaled = tax1Value.setScale(2, RoundingMode.HALF_UP);
        BigDecimal cgstScaled = tax2Value.setScale(2, RoundingMode.HALF_UP);
        billDTO.setTax1DisplayName(sgstScaled.compareTo(BigDecimal.ZERO) != 0 ? "SGST" : null);
        billDTO.setTax1Value(sgstScaled.compareTo(BigDecimal.ZERO) != 0 ? sgstScaled : null);
        billDTO.setTax2DisplayName(cgstScaled.compareTo(BigDecimal.ZERO) != 0 ? "CGST" : null);
        billDTO.setTax2Value(cgstScaled.compareTo(BigDecimal.ZERO) != 0 ? cgstScaled : null);
        return billDTO;
    }

    public static String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(chars.length());
            stringBuilder.append(chars.charAt(randomIndex));
        }
        return stringBuilder.toString();
    }
}

