/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.service.RequestService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class RequestServiceImpl
implements RequestService {
    private final String LOCALHOST_IPV4 = "127.0.0.1";
    private final String LOCALHOST_IPV6 = "0:0:0:0:0:0:0:1";

    public String getClientIp(HttpServletRequest request) {
        String ipAddress = Optional.ofNullable(request.getHeader("X-Forwarded-For")).filter(ip -> !ip.isEmpty() && !"unknown".equalsIgnoreCase((String)ip)).orElseGet(() -> Optional.ofNullable(request.getHeader("Proxy-Client-IP")).filter(ip -> !ip.isEmpty() && !"unknown".equalsIgnoreCase((String)ip)).orElseGet(() -> Optional.ofNullable(request.getHeader("WL-Proxy-Client-IP")).filter(ip -> !ip.isEmpty() && !"unknown".equalsIgnoreCase((String)ip)).orElse(request.getRemoteAddr())));
        if (ipAddress != null && ipAddress.contains(",")) {
            ipAddress = ipAddress.split(",")[0].trim();
        }
        return ipAddress;
    }
}

