/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.dto.ProductDTO;
import com.chataak.api.dto.ProductScanDto;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.OrganizationStoreEntity;
import com.chataak.api.entity.ProductImage;
import com.chataak.api.entity.ProductPromotion;
import com.chataak.api.entity.ProductVideo;
import com.chataak.api.entity.Products;
import com.chataak.api.entity.ShoppingCart;
import com.chataak.api.entity.ShoppingCartProducts;
import com.chataak.api.entity.User;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.OrganizationStoreEntityRepository;
import com.chataak.api.repo.OrganizationStoreRepository;
import com.chataak.api.repo.ProductPromotionRepository;
import com.chataak.api.repo.ProductsRepository;
import com.chataak.api.repo.SessionHistoryRepository;
import com.chataak.api.repo.ShoppingCartProductsRepository;
import com.chataak.api.repo.ShoppingCartRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.ProductsService;
import jakarta.persistence.EntityNotFoundException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class ProductsServiceImpl
implements ProductsService {
    @Autowired
    private ProductsRepository productsRepository;
    @Autowired
    private OrganizationStoreRepository organizationStoreRepository;
    @Autowired
    private ShoppingCartRepository shoppingCartRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ProductPromotionRepository productPromotionRepository;
    @Autowired
    private ShoppingCartProductsRepository cartProductsRepository;
    @Autowired
    private SessionHistoryRepository historyRepository;
    @Autowired
    private OrganizationStoreEntityRepository organizationStoreEntityRepository;

    private Products convertToEntity(ProductDTO productDTO) {
        Products product = new Products();
        return product;
    }

    public Map<String, Object> scanProductsByBarcode(String barcode, Integer storeKeyId) {
        if (storeKeyId == null) {
            throw new ResourceNotFoundException("Sorry, the store you are looking for is currently unavailable. Please try again later.");
        }
        if (barcode == null) {
            throw new ResourceNotFoundException("Sorry, we couldn't find any product associated with the scanned barcode. Please make sure you've scanned the correct barcode.");
        }
        OrganizationStoreEntity stores = this.organizationStoreEntityRepository.findByProductsBarCodeAndStore(barcode, storeKeyId);
        if (stores == null || !stores.getStatus().equals((short)1) || !stores.getProducts().getStatus().equals((short)1)) {
            throw new ResourceNotFoundException("Sorry, this product is not available in Our Stores.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", 1);
        map.put("message", "success");
        map.put("productKeyId", stores.getProducts().getProductId());
        return map;
    }

    public Map<String, List<?>> scanProductByBarcode(long productKeyId, Integer storeKeyId, Integer quantity, Integer promotionKeyId) {
        Optional cartProductOpt;
        quantity = quantity == null ? 0 : quantity;
        promotionKeyId = promotionKeyId == null ? 0 : promotionKeyId;
        int displayQuantity = quantity;
        OrganizationStoreEntity storeEntity = (OrganizationStoreEntity)this.organizationStoreEntityRepository.findByStoreAndProducts(storeKeyId, Long.valueOf(productKeyId)).orElseThrow(() -> new ResourceNotFoundException("Sorry, this product is not available in Our Stores."));
        OrganizationStore organizationStore = storeEntity.getStore();
        Products scannedProduct = storeEntity.getProducts();
        if (!storeEntity.getStatus().equals((short)1) || organizationStore.getStatus() != 1 || storeEntity.getProducts().getStatus() != 1) {
            throw new ResourceNotFoundException("Sorry, this product is not available in Our Stores.");
        }
        Integer availableQty = storeEntity.getProducts().getQuantity();
        if (availableQty == null || availableQty == 0) {
            throw new ResourceNotFoundException("The product is unavailable in the store. Please check back later.");
        }
        if (quantity > availableQty) {
            quantity = availableQty;
        }
        displayQuantity = quantity;
        String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        User user = (User)this.userRepository.findByMobileNumber(username).orElseThrow(() -> new ResourceNotFoundException("User not found."));
        ShoppingCart cart = this.shoppingCartRepository.findLatestValidCart(user.getUserKeyId(), storeKeyId, new Date()).orElse(null);
        Optional optional = cartProductOpt = cart != null ? this.cartProductsRepository.findByCartKeyIdAndProductKeyId(cart.getCartKeyId(), Long.valueOf(productKeyId)) : Optional.empty();
        if (promotionKeyId != 0 && cartProductOpt.isPresent() && ((ShoppingCartProducts)cartProductOpt.get()).getPromotion() != null) {
            promotionKeyId = ((ShoppingCartProducts)cartProductOpt.get()).getPromotion().getPromotionId();
        }
        BigDecimal originalPrice = storeEntity.getSellingPrice();
        ProductPromotion productPromotion = this.resolveProductPromotion(promotionKeyId, scannedProduct, organizationStore, storeEntity);
        BigDecimal discountPercentage = productPromotion != null && productPromotion.getPromotionPercentage() != null ? productPromotion.getPromotionPercentage() : BigDecimal.ZERO;
        BigDecimal discountAmount = productPromotion != null && productPromotion.getPromotionAmount() != null ? productPromotion.getPromotionAmount() : BigDecimal.ZERO;
        BigDecimal discount = discountPercentage.compareTo(BigDecimal.ZERO) > 0 ? originalPrice.multiply(discountPercentage.divide(new BigDecimal("100"))) : discountAmount;
        BigDecimal sellingPrice = originalPrice.subtract(discount);
        BigDecimal total = quantity > 0 ? sellingPrice.multiply(BigDecimal.valueOf(quantity.intValue())) : BigDecimal.ZERO;
        HashMap response = new HashMap();
        List productDetails = this.buildProductDetails(scannedProduct, storeEntity, cart, (ShoppingCartProducts)cartProductOpt.orElse(null), displayQuantity, sellingPrice, total, originalPrice, productPromotion);
        response.put("productDetails", productDetails);
        response.put("image", this.buildImageList(scannedProduct));
        response.put("video", this.buildVideoList(scannedProduct));
        return response;
    }

    private ProductPromotion resolveProductPromotion(Integer promotionKeyId, Products scannedProduct, OrganizationStore organizationStore, OrganizationStoreEntity storeEntity) {
        ProductPromotion productPromotion = null;
        Date now = new Date();
        if (promotionKeyId != 0) {
            productPromotion = (ProductPromotion)this.productPromotionRepository.findById((Object)promotionKeyId).orElseThrow(() -> new ResourceNotFoundException("Promotion not found with id: " + promotionKeyId));
            if (productPromotion.getStatus() == -1) {
                throw new ResourceNotFoundException("Promotion not found with id: " + promotionKeyId);
            }
            if (productPromotion.getValidTill().before(now) || productPromotion.getValidFrom().after(now)) {
                productPromotion = null;
            }
        }
        List<String> activeCategories = scannedProduct.getCategories().parallelStream().filter(c -> c.getStatus() == 1).map(CategoryManager::getName).toList();
        Integer orgId = organizationStore.getOrganization().getId();
        Integer merchantOrOrgId = organizationStore.getMerchantId() != null ? organizationStore.getMerchantId().getId() : organizationStore.getOrganization().getId();
        Integer storeId = organizationStore.getStoreKeyId();
        Long productId = scannedProduct.getProductId();
        if (productPromotion == null) {
            productPromotion = this.productPromotionRepository.findPromotionByProductOrCategory(orgId, merchantOrOrgId, Short.valueOf((short)1), now, now, productId, activeCategories).orElse(null);
        }
        return productPromotion;
    }

    private List<Map<String, Object>> buildProductDetails(Products product, OrganizationStoreEntity storeEntity, ShoppingCart cart, ShoppingCartProducts cartProduct, int displayQuantity, BigDecimal sellingPrice, BigDecimal total, BigDecimal originalPrice, ProductPromotion productPromotion) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("id", product.getProductId());
        details.put("name", product.getProductName());
        details.put("productDescription", product.getProductDescription());
        details.put("availableQty", storeEntity.getQuantity());
        details.put("displayQuantity", displayQuantity);
        details.put("sellingPrice", sellingPrice.setScale(2, RoundingMode.HALF_UP));
        details.put("totalAmount", total.setScale(2, RoundingMode.HALF_UP));
        details.put("originalPrice", originalPrice.setScale(2, RoundingMode.HALF_UP));
        if (cart != null) {
            details.put("cartKeyId", cart.getCartKeyId());
        } else {
            details.put("cartKeyId", 0);
        }
        if (cartProduct != null) {
            details.put("isUserAdded", true);
            details.put("userAddedQty", cartProduct.getQuantity());
            details.put("promotionKeyId", cartProduct.getPromotion() != null ? cartProduct.getPromotion().getPromotionId() : 0);
            details.put("discountPercentage", cartProduct.getDiscountPercentage() != null ? cartProduct.getDiscountPercentage() : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            details.put("discountAmount", cartProduct.getDiscountAmount() != null ? cartProduct.getDiscountAmount() : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        } else {
            details.put("isUserAdded", false);
            details.put("userAddedQty", 0);
            details.put("promotionKeyId", productPromotion != null ? productPromotion.getPromotionId() : 0);
            details.put("discountPercentage", productPromotion != null && productPromotion.getPromotionPercentage() != null ? productPromotion.getPromotionPercentage().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            details.put("discountAmount", productPromotion != null && productPromotion.getPromotionAmount() != null ? productPromotion.getPromotionAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        }
        List categoryPairs = Stream.concat(product.getBrand() != null ? Stream.of(new AbstractMap.SimpleEntry<String, String>("Brand", product.getBrand().getName())) : Stream.empty(), product.getCategories().stream().filter(cat -> cat.getName() != null && cat.getLabel() != null).map(cat -> new AbstractMap.SimpleEntry<String, String>(cat.getLabel(), cat.getName()))).limit(3L).collect(Collectors.toList());
        IntStream.range(0, 3).forEach(i -> {
            details.put("category" + (i + 1), i < categoryPairs.size() ? (Object)((Map.Entry)categoryPairs.get(i)).getValue() : null);
            details.put("displayNameCategory" + (i + 1), i < categoryPairs.size() ? (Object)((Map.Entry)categoryPairs.get(i)).getKey() : null);
        });
        return List.of(details);
    }

    private List<Map<String, Object>> buildImageList(Products product) {
        ArrayList<Map<String, Object>> imageList = new ArrayList<Map<String, Object>>();
        int totalImages = Math.min(10, product.getProductImages().size());
        for (int i = 1; i <= totalImages; ++i) {
            String imageURL = this.getImageURL(product, i);
            if (imageURL == null) continue;
            HashMap<String, Object> imageMap = new HashMap<String, Object>();
            imageMap.put("id", i);
            imageMap.put("image", imageURL);
            imageList.add(imageMap);
        }
        return imageList;
    }

    private List<Map<String, Object>> buildVideoList(Products product) {
        ArrayList<Map<String, Object>> videoList = new ArrayList<Map<String, Object>>();
        int totalVideos = Math.min(3, product.getProductVideos().size());
        for (int i = 1; i <= totalVideos; ++i) {
            String videoURL = this.getVideoURL(product, i);
            String videoThumbnail = this.getVideoThumbnail(product, i);
            if (videoURL == null) continue;
            HashMap<String, Object> videoMap = new HashMap<String, Object>();
            videoMap.put("id", i);
            videoMap.put("videoThumbnail", videoThumbnail);
            videoMap.put("video", videoURL);
            videoList.add(videoMap);
        }
        return videoList;
    }

    private String getImageURL(Products product, int index) {
        String imageUrl;
        List images = product.getProductImages();
        if (images != null && index >= 1 && index <= images.size() && (imageUrl = ((ProductImage)images.get(index - 1)).getImageUrl()) != null && !imageUrl.isEmpty()) {
            return "https://dev-api.chataak.in/images/thumbnail/" + imageUrl.substring(imageUrl.lastIndexOf("/") + 1);
        }
        return "https://dev-api.chataak.in/images/profile/default-product-image.png";
    }

    private String getVideoURL(Products product, int index) {
        String videoUrl;
        List videos = product.getProductVideos();
        if (videos != null && index >= 1 && index <= videos.size() && (videoUrl = ((ProductVideo)videos.get(index - 1)).getVideoUrl()) != null && !videoUrl.isEmpty()) {
            return "https://dev-api.chataak.in/images/video/" + videoUrl.substring(videoUrl.lastIndexOf("/") + 1);
        }
        return null;
    }

    private String getVideoThumbnail(Products product, int index) {
        String thumbnailUrl;
        List videos = product.getProductVideos();
        if (videos != null && index >= 1 && index <= videos.size() && (thumbnailUrl = ((ProductVideo)videos.get(index - 1)).getThumbnailUrl()) != null && !thumbnailUrl.isEmpty()) {
            String filename = thumbnailUrl.substring(thumbnailUrl.lastIndexOf("/") + 1);
            return "https://dev-api.chataak.in/images/video/tn/" + filename;
        }
        return null;
    }

    private ProductScanDto convertToProductScanDto(Products product) {
        ProductScanDto productScanDto = new ProductScanDto();
        productScanDto.setProductKeyId(product.getProductId());
        productScanDto.setProductName(product.getProductName());
        productScanDto.setProductDescription(product.getProductDescription());
        ArrayList categories = product.getCategories();
        if (categories == null) {
            categories = new ArrayList();
        }
        List categoryNames = categories.parallelStream().map(CategoryManager::getName).collect(Collectors.toList());
        productScanDto.setCategory(categories);
        productScanDto.setSellingUOM(product.getSellingUOM() != null ? product.getSellingUOM().getUnit() : null);
        productScanDto.setSellingPrice(product.getSellingPrice());
        return productScanDto;
    }

    public List<Map<String, Object>> getSimilarProducts(Long productKeyId, Integer storeKeyId) {
        short activeStatus = 1;
        Products scannedProduct = (Products)this.productsRepository.findById((Object)productKeyId).orElseThrow(() -> new ResourceNotFoundException("Product not found"));
        OrganizationStore organizationStore = (OrganizationStore)this.organizationStoreRepository.findById((Object)storeKeyId).orElseThrow(() -> new ResourceNotFoundException("Store not found"));
        this.validateEntityStatus(scannedProduct.getStatus().shortValue(), "Product not found");
        this.validateEntityStatus(organizationStore.getStatus().shortValue(), "Store not found");
        List similarProducts = this.organizationStoreEntityRepository.findSimilarProducts(organizationStore, Short.valueOf(activeStatus), scannedProduct.getCategories(), scannedProduct.getBrand(), productKeyId);
        if (similarProducts.isEmpty()) {
            throw new EntityNotFoundException("Products not found for the specified category");
        }
        return similarProducts.stream().map(arg_0 -> this.mapProductToDetails(arg_0)).collect(Collectors.toList());
    }

    private void validateEntityStatus(short status, String errorMessage) {
        if (status != 1) {
            throw new ResourceNotFoundException(errorMessage);
        }
    }

    private Map<String, Object> mapProductToDetails(OrganizationStoreEntity organizationStoreEntity) {
        HashMap<String, Object> productDetailsMap = new HashMap<String, Object>();
        Products product = organizationStoreEntity.getProducts();
        productDetailsMap.put("productKeyId", product.getProductId());
        productDetailsMap.put("productName", product.getProductName());
        productDetailsMap.put("productDescription", product.getProductDescription());
        productDetailsMap.put("sellingPrice", organizationStoreEntity.getSellingPrice());
        productDetailsMap.put("categories", this.getCategories(product));
        String imageURL = product.getProductImages().parallelStream().map(ProductImage::getImageUrl).findFirst().orElse("https://dev-api.chataak.in/images/profile/default-product-image.png");
        if (imageURL != null && !imageURL.isEmpty()) {
            String filename = imageURL.substring(imageURL.lastIndexOf("/") + 1);
            productDetailsMap.put("image", "https://dev-api.chataak.in/images/thumbnail/" + filename);
        } else {
            productDetailsMap.put("image", "https://dev-api.chataak.in/images/profile/default-product-image.png");
        }
        return productDetailsMap;
    }

    public void update(Long productKeyId, BigDecimal sellingPrice, int quantity) {
        Products scannedProduct = (Products)this.productsRepository.findById((Object)productKeyId).orElseThrow(() -> new ResourceNotFoundException("Product not found"));
        scannedProduct.setSellingPrice(sellingPrice);
        this.productsRepository.save((Object)scannedProduct);
    }

    private List<String> getCategories(Products product) {
        ArrayList categories = product.getCategories();
        if (categories == null) {
            categories = new ArrayList();
        }
        return categories.parallelStream().map(CategoryManager::getName).collect(Collectors.toList());
    }
}

