/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.service.impl;

import com.chataak.api.entity.Invoice;
import com.chataak.api.entity.Order;
import com.chataak.api.entity.OrderProducts;
import com.chataak.api.entity.OrganizationStoreCoupons;
import com.chataak.api.exception.ResourceNotFoundException;
import com.chataak.api.repo.InvoiceRepository;
import com.chataak.api.repo.OrderProductsRepository;
import com.chataak.api.repo.OrderRepository;
import com.chataak.api.service.InvoiceService;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private final String imageUrlBase = "https://dev-api.chataak.in/images/invoice/";
    private final String invoiceDirectory = "/var/www/dev-api.chataak.in/images/invoice/";
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private final SpringTemplateEngine templateEngine;
    @Autowired
    private InvoiceRepository invoiceRepository;
    @Autowired
    private OrderProductsRepository orderProductsRepository;

    public InvoiceServiceImpl(SpringTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String generateInvoicePDF(Integer orderKeyId) throws Exception {
        Order order = (Order)this.orderRepository.findById((Object)orderKeyId).orElseThrow(() -> new ResourceNotFoundException("Order not found with id: " + orderKeyId));
        Context context = new Context();
        context.setVariable("orderNumber", (Object)order.getOrderNo());
        String invoiceNumber = "INV-" + order.getOrderNo();
        context.setVariable("invoiceNumber", (Object)invoiceNumber);
        ZoneId istZoneId = ZoneId.of("Asia/Kolkata");
        ZonedDateTime utcDateTime = order.getOrderDate().toInstant().atZone(ZoneId.of("UTC"));
        ZonedDateTime istDateTime = utcDateTime.withZoneSameInstant(istZoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedOrderDate = istDateTime.format(formatter);
        context.setVariable("orderDate", (Object)formattedOrderDate);
        Invoice existingInvoice = this.invoiceRepository.findByInvoiceNumber(invoiceNumber);
        if (existingInvoice != null) {
            return existingInvoice.getInvoiceUrl();
        }
        context.setVariable("storeName", (Object)order.getStore().getStoreDisplayName());
        context.setVariable("storeLocation", (Object)order.getStore().getAddress());
        context.setVariable("storeCity", (Object)order.getStore().getCity());
        context.setVariable("storeState", (Object)order.getStore().getState());
        context.setVariable("storeCountry", (Object)order.getStore().getCountry());
        BigDecimal totalAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal totalCGST = BigDecimal.ZERO;
        BigDecimal totalSGST = BigDecimal.ZERO;
        List orderProducts = this.orderProductsRepository.findByOrder(order).stream().filter(op -> op.getProducts() != null).collect(Collectors.toList());
        ArrayList productsForInvoice = new ArrayList();
        for (OrderProducts product : orderProducts) {
            if (product.getTaxableAmount() == null || product.getQuantity() == null) continue;
            BigDecimal productTotal = product.getTaxableAmount().multiply(BigDecimal.valueOf(product.getQuantity().intValue()));
            totalAmountWithoutTax = totalAmountWithoutTax.add(productTotal);
            BigDecimal cgstAmount = product.getCgstAmount() != null ? BigDecimal.valueOf(product.getCgstAmount()) : BigDecimal.ZERO;
            BigDecimal sgstAmount = product.getSgstAmount() != null ? BigDecimal.valueOf(product.getSgstAmount()) : BigDecimal.ZERO;
            totalCGST = totalCGST.add(cgstAmount);
            totalSGST = totalSGST.add(sgstAmount);
            BigDecimal productTotalWithTax = productTotal.add(cgstAmount).add(sgstAmount);
            HashMap<String, Object> productDetails = new HashMap<String, Object>();
            productDetails.put("productName", product.getProducts().getProductName());
            productDetails.put("price", product.getActualSellingPrice());
            productDetails.put("quantity", product.getQuantity());
            productDetails.put("cgstAmount", cgstAmount);
            productDetails.put("sgstAmount", sgstAmount);
            productDetails.put("totalTaxAmount", cgstAmount.add(sgstAmount));
            productDetails.put("productTotal", productTotalWithTax);
            productsForInvoice.add(productDetails);
        }
        BigDecimal netAmount = totalAmountWithoutTax.add(totalCGST).add(totalSGST);
        netAmount = netAmount != null ? netAmount : BigDecimal.ZERO;
        OrganizationStoreCoupons coupon = this.orderRepository.findCouponByOrderKeyId(Long.valueOf(orderKeyId.intValue()));
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (coupon != null) {
            discountAmount = order.getCouponAmount() != null ? order.getCouponAmount() : BigDecimal.ZERO;
            System.out.println("Coupon Name: " + coupon.getCouponName());
            System.out.println("Coupon Amount: " + discountAmount);
            context.setVariable("couponName", (Object)(coupon.getCouponName() != null ? coupon.getCouponName() : "No Discount"));
        } else {
            context.setVariable("couponName", (Object)"No Discount");
        }
        BigDecimal finalAmount = netAmount.subtract(discountAmount != null ? discountAmount : BigDecimal.ZERO);
        context.setVariable("discountAmount", (Object)discountAmount.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("finalAmount", (Object)finalAmount.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("discountAmount", (Object)discountAmount.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("totalAmountWithoutTax", (Object)totalAmountWithoutTax.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("totalCGST", (Object)totalCGST.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("totalSGST", (Object)totalSGST.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("netAmount", (Object)netAmount.setScale(2, RoundingMode.HALF_UP));
        context.setVariable("products", productsForInvoice);
        String htmlContent = this.templateEngine.process("invoice-template", (IContext)context);
        String fileName = invoiceNumber.replaceAll("/", "-") + ".pdf";
        String outputFilePath = "/var/www/dev-api.chataak.in/images/invoice/" + fileName;
        String invoiceUrl = "https://dev-api.chataak.in/images/invoice/" + fileName;
        try (FileOutputStream os = new FileOutputStream(outputFilePath);){
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocumentFromString(htmlContent);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
        }
        Invoice invoice = new Invoice();
        invoice.setOrder(order);
        invoice.setInvoiceNumber(invoiceNumber);
        invoice.setInvoiceUrl(invoiceUrl);
        invoice.setCreatedOn(LocalDateTime.now());
        this.invoiceRepository.save((Object)invoice);
        return invoiceUrl;
    }

    public Map<String, String> getInvoiceUrl(Long invoiceId, Integer orderKeyId) {
        HashMap<String, String> response = new HashMap<String, String>();
        if (invoiceId != null) {
            Optional invoiceOptional = this.invoiceRepository.findById((Object)invoiceId);
            if (invoiceOptional.isPresent()) {
                response.put("invoiceUrl", ((Invoice)invoiceOptional.get()).getInvoiceUrl());
                return response;
            }
            throw new ResourceNotFoundException("Invoice not found with invoiceId: " + invoiceId);
        }
        if (orderKeyId != null) {
            Optional invoiceOptional = this.invoiceRepository.findByOrder_OrderKeyId(Long.valueOf(orderKeyId.intValue()));
            if (invoiceOptional.isPresent()) {
                response.put("invoiceUrl", ((Invoice)invoiceOptional.get()).getInvoiceUrl());
                return response;
            }
            throw new ResourceNotFoundException("Invoice not found for order with orderKeyId: " + orderKeyId);
        }
        throw new IllegalArgumentException("Either invoiceId or orderKeyId must be provided.");
    }
}

