/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.repo;

import com.chataak.api.entity.ShoppingCart;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ShoppingCartRepository
extends JpaRepository<ShoppingCart, Integer> {
    public long countByUser_UserKeyIdAndStore_StoreKeyId(Integer var1, Integer var2);

    public List<ShoppingCart> findByUser_UserKeyIdAndStore_StoreKeyId(Integer var1, Integer var2);

    @Query(value="SELECT * FROM shopping_cart WHERE userKeyId = :userKeyId AND storeKeyId = :storeKeyId", nativeQuery=true)
    public List<ShoppingCart> findByUserKeyIdAndStoreKeyId(@Param(value="userKeyId") Integer var1, @Param(value="storeKeyId") Integer var2);

    public List<ShoppingCart> findByUser_UserKeyId(Integer var1);

    @Query(value="SELECT sc FROM ShoppingCart sc WHERE sc.user.userKeyId = :userKeyId AND sc.cartValidTill > CURRENT_DATE AND sc.cartCompletedOn IS NULL AND sc.deletedBy IS NULL")
    public List<ShoppingCart> findActiveCartsByUser(@Param(value="userKeyId") int var1);

    @Query(value="SELECT c FROM ShoppingCart c WHERE c.user.userKeyId = :userKeyId AND c.store.storeKeyId = :storeKeyId AND c.cartValidTill > :now AND c.cartCompletedOn IS NULL AND c.deletedOn IS NULL ORDER BY c.cartValidTill DESC LIMIT 1")
    public Optional<ShoppingCart> findLatestValidCart(@Param(value="userKeyId") Integer var1, @Param(value="storeKeyId") Integer var2, @Param(value="now") Date var3);
}

