/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.repo;

import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.ProductPromotion;
import com.chataak.api.entity.Products;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ProductPromotionRepository
extends JpaRepository<ProductPromotion, Integer> {
    public List<ProductPromotion> findByStore_StoreKeyId(Integer var1);

    public int countByStore_StoreKeyId(Long var1);

    public List<ProductPromotion> findByProduct(Products var1);

    public List<ProductPromotion> findByStore_StoreKeyIdAndProduct_ProductId(Integer var1, Long var2);

    @Query(value="SELECT pp FROM ProductPromotion pp WHERE pp.store = :store AND pp.categories LIKE CONCAT('%', :category, '%') AND pp.status != -1")
    public List<ProductPromotion> findByStoreAndCategory(@Param(value="store") OrganizationStore var1, @Param(value="category") String var2);

    public List<ProductPromotion> findByStoreAndCategoriesIn(OrganizationStore var1, List<String> var2);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_store ps ON p.promotion_id = ps.promotion_id LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id=1 ) AND ps.store_key_id = :storeKeyId AND p.flag_type = :flagType AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList)) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByStoreAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="storeKeyId") Integer var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId LEFT JOIN promotion_city ps ON ps.promotionId = p.promotion_id WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id=1) AND ps.city = :city AND p.flag_type = :flagType AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList)) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByCityAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="city") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId LEFT JOIN promotion_state ps ON ps.promotionId = p.promotion_id WHERE(p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id=1) AND ps.state = :state AND p.flag_type = :flagType AND p.status = :status AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList)) AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByStateAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="state") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id=1) AND p.country = :country AND p.flag_type = :flagType AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList)) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByCountryAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT p.* FROM promotion p WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId  OR p.organization_id=1  ) AND p.country = :country AND p.flag_type = :flagType AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByCountry(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT p.* FROM promotion p WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId  OR p.organization_id=1  ) AND :city IN (SELECT city FROM promotion_city WHERE promotionId = p.promotion_id) AND p.flag_type = :flagType AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByCity(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="city") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT p.* FROM promotion p JOIN promotion_store ps ON p.promotion_id = ps.promotion_id WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id=1 ) AND ps.store_key_id = :storeKeyId AND p.flag_type = :flagType AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByStore(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="storeKeyId") Integer var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT p.* FROM promotion p WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId  OR p.organization_id=1  )AND :state IN (SELECT state FROM promotion_state WHERE promotionId = p.promotion_id) AND p.flag_type = :flagType AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByStates(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="state") String var3, @Param(value="flagType") String var4, @Param(value="status") Short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId LEFT JOIN promotion_state ps ON ps.promotionId = p.promotion_id LEFT JOIN promotion_city pc ON pc.promotionId = p.promotion_id LEFT JOIN promotion_store pss ON p.promotion_id = pss.promotion_id WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id = 1) AND ((p.country = :country AND p.flag_type = 'country') OR (ps.state = :state AND p.flag_type = 'state') OR (pc.city = :city AND p.flag_type = 'city') OR (pss.store_key_id = :storeKeyId AND p.flag_type = 'store')) AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList) OR pp.product_id IS NULL OR ppc.categories IS NULL) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill GROUP BY p.promotion_id", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByCountryAndStateProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="state") String var4, @Param(value="city") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") Short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9, @Param(value="productId") Long var10, @Param(value="categoriesList") List<String> var11);

    @Query(value="SELECT * FROM (   SELECT DISTINCT p.*,          CASE              WHEN pp.product_id = :productId THEN 1              WHEN ppc.categories IN (:categoriesList) THEN 2              WHEN pss.store_key_id = :storeKeyId THEN 3              WHEN pc.city = :city THEN 4              WHEN ps.state = :state THEN 5              WHEN p.country = :country THEN 6              ELSE 999          END AS priority   FROM promotion p   LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id   LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId   LEFT JOIN promotion_store pss ON p.promotion_id = pss.promotion_id   LEFT JOIN promotion_city pc ON pc.promotionId = p.promotion_id   LEFT JOIN promotion_state ps ON ps.promotionId = p.promotion_id   WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id = 1)     AND p.status = :status     AND p.valid_from <= :validFrom     AND p.valid_till >= :validTill ) AS promo WHERE promo.priority < 999 ORDER BY promo.priority ASC LIMIT 1", nativeQuery=true)
    public Optional<ProductPromotion> findPromotionInPriorityOrder(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="city") String var3, @Param(value="state") String var4, @Param(value="country") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") Short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9, @Param(value="productId") Long var10, @Param(value="categoriesList") List<String> var11);

    @Query(value="SELECT * FROM (   SELECT DISTINCT p.*,          CASE              WHEN pp.product_id = :productId THEN 1              WHEN ppc.categories IN (:categoriesList) THEN 2              ELSE 999          END AS priority   FROM promotion p   LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id   LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId   WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id = 1)     AND p.status = :status     AND p.valid_from <= :validFrom     AND p.valid_till >= :validTill ) AS promo WHERE promo.priority < 999 ORDER BY promo.priority ASC LIMIT 1", nativeQuery=true)
    public Optional<ProductPromotion> findPromotionByProductOrCategory(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="status") Short var3, @Param(value="validFrom") Date var4, @Param(value="validTill") Date var5, @Param(value="productId") Long var6, @Param(value="categoriesList") List<String> var7);

    @Query(value="SELECT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId LEFT JOIN promotion_state ps ON ps.promotionId = p.promotion_id LEFT JOIN promotion_city pc ON pc.promotionId = p.promotion_id LEFT JOIN promotion_store pss ON p.promotion_id = pss.promotion_id WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id = 1) AND ((:country IS NULL OR (p.country = :country AND p.flag_type = 'country')) OR (:state IS NULL OR (ps.state = :state AND p.flag_type = 'state')) OR (:city IS NULL OR (pc.city = :city AND p.flag_type = 'city')) OR (:storeKeyId IS NULL OR (pss.store_key_id = :storeKeyId AND p.flag_type = 'store'))) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill GROUP BY p.promotion_id", nativeQuery=true)
    public List<ProductPromotion> findPromotionsByAll(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="state") String var4, @Param(value="city") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") Short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9);

    @Query(value="SELECT DISTINCT p.* FROM promotion p LEFT JOIN promotion_product pp ON p.promotion_id = pp.promotion_id LEFT JOIN promotion_product_categories ppc ON p.promotion_id = ppc.promotionId LEFT JOIN promotion_state ps ON ps.promotionId = p.promotion_id LEFT JOIN promotion_city pc ON pc.promotionId = p.promotion_id LEFT JOIN promotion_store pss ON p.promotion_id = pss.promotion_id WHERE (p.organization_id = :organizationId OR p.organization_id = :orgId OR p.organization_id = 1) AND ((p.country = :country AND p.flag_type = 'country') OR (ps.state = :state AND p.flag_type = 'state') OR (pc.city = :city AND p.flag_type = 'city') OR (pss.store_key_id = :storeKeyId AND p.flag_type = 'store')) AND (pp.product_id = :productId OR ppc.categories IN (:categoriesList) OR pp.product_id IS NULL OR ppc.categories IS NULL) AND p.status = :status AND p.valid_from <= :validFrom AND p.valid_till >= :validTill GROUP BY p.promotion_id LIMIT 1", nativeQuery=true)
    public Optional<ProductPromotion> findPromotionsByCountryOrStateProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="state") String var4, @Param(value="city") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") Short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9, @Param(value="productId") Long var10, @Param(value="categoriesList") List<String> var11);
}

