/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.repo;

import com.chataak.api.entity.OrganizationStoreCoupons;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OrganizationStoreCouponsRepository
extends JpaRepository<OrganizationStoreCoupons, Long> {
    @Query(value="SELECT DISTINCT c.* FROM coupons c LEFT JOIN coupon_store cs ON c.coupon_id = cs.coupon_id LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1)AND cs.store_key_id = :storeKeyId AND c.flag_type = :flagType AND (cp.product_id = :productId OR cpc.categories IN (:categoriesList)) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByStoreAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="storeKeyId") Integer var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT c.* FROM coupons c LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id LEFT JOIN coupon_city cc ON cc.coupon_id = c.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1)AND cc.city = :city AND c.flag_type = :flagType AND (cp.product_id = :productId OR cpc.categories IN (:categoriesList)) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByCityAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="city") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT c.* FROM coupons c LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id LEFT JOIN coupon_state cs ON cs.coupon_id = c.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND cs.state = :state AND c.flag_type = :flagType AND (cp.product_id = :productId OR cpc.categories IN (:categoriesList)) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByStateAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="state") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT DISTINCT c.* FROM coupons c LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND c.country = :country AND c.flag_type = :flagType AND (cp.product_id = :productId OR cpc.categories IN (:categoriesList)) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByCountryAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7, @Param(value="productId") Long var8, @Param(value="categoriesList") List<String> var9);

    @Query(value="SELECT c.* FROM coupons c WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND c.country = :country AND c.flag_type = :flagType AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByCountry(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT c.* FROM coupons c WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND :city IN (SELECT city FROM coupon_city WHERE coupon_id = c.coupon_id) AND c.flag_type = :flagType AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByCity(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="city") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT c.* FROM coupons c JOIN coupon_store cs ON c.coupon_id = cs.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND cs.store_key_id = :storeKeyId AND c.flag_type = :flagType AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByStore(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="storeKeyId") Integer var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT c.* FROM coupons c WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id=1) AND :state IN (SELECT state FROM coupon_state WHERE coupon_id = c.coupon_id) AND c.flag_type = :flagType AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByStates(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="state") String var3, @Param(value="flagType") String var4, @Param(value="status") short var5, @Param(value="validFrom") Date var6, @Param(value="validTill") Date var7);

    @Query(value="SELECT c.* FROM coupons c LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id LEFT JOIN coupon_state cs ON cs.coupon_id = c.coupon_id LEFT JOIN coupon_city cc ON cc.coupon_id = c.coupon_id LEFT JOIN coupon_store cst ON c.coupon_id = cst.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id = 1) AND ((:country IS NULL OR (c.country = :country AND c.flag_type = 'country')) OR (:state IS NULL OR (cs.state = :state AND c.flag_type = 'state')) OR (:city IS NULL OR (cc.city = :city AND c.flag_type = 'city')) OR (:storeKeyId IS NULL OR (cst.store_key_id = :storeKeyId AND c.flag_type = 'store'))) AND (:productId IS NULL OR cp.product_id = :productId) AND (:categoriesList IS NULL OR cpc.categories IN (:categoriesList)) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill GROUP BY c.coupon_id", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByAllAndProductOrCategories(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="state") String var4, @Param(value="city") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9, @Param(value="productId") Long var10, @Param(value="categoriesList") List<String> var11);

    @Query(value="SELECT c.* FROM coupons c LEFT JOIN coupon_product cp ON c.coupon_id = cp.coupon_id LEFT JOIN coupon_product_categories cpc ON c.coupon_id = cpc.coupon_id LEFT JOIN coupon_state cs ON cs.coupon_id = c.coupon_id LEFT JOIN coupon_city cc ON cc.coupon_id = c.coupon_id LEFT JOIN coupon_store cst ON c.coupon_id = cst.coupon_id WHERE (c.organization_id = :organizationId OR c.organization_id = :orgId OR c.organization_id = 1) AND ((:country IS NULL OR (c.country = :country AND c.flag_type = 'country')) OR (:state IS NULL OR (cs.state = :state AND c.flag_type = 'state')) OR (:city IS NULL OR (cc.city = :city AND c.flag_type = 'city')) OR (:storeKeyId IS NULL OR (cst.store_key_id = :storeKeyId AND c.flag_type = 'store'))) AND c.coupon_status = :status AND c.valid_from <= :validFrom AND c.valid_till >= :validTill GROUP BY c.coupon_id", nativeQuery=true)
    public List<OrganizationStoreCoupons> findCouponsByAll(@Param(value="organizationId") Integer var1, @Param(value="orgId") Integer var2, @Param(value="country") String var3, @Param(value="state") String var4, @Param(value="city") String var5, @Param(value="storeKeyId") Integer var6, @Param(value="status") short var7, @Param(value="validFrom") Date var8, @Param(value="validTill") Date var9);
}

