/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.exception;

import com.chataak.api.exception.ErrorDetails;
import com.chataak.api.exception.MobileNumberAlreadyExistsException;
import com.chataak.api.exception.MobileNumberInvalidException;
import com.chataak.api.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> globalExceptionHandling(Exception exception, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(Integer.valueOf(0), exception.getMessage());
        logger.warn("globalExceptionHandling Message:" + exception.getClass() + exception.getMessage());
        return new ResponseEntity((Object)errorDetails, (HttpStatusCode)HttpStatus.OK);
    }

    private ErrorDetails createErrorDetails(String message, WebRequest request) {
        return new ErrorDetails(Integer.valueOf(0), message);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<?> handleNotFoundExceptions(Exception exception, WebRequest request) {
        ErrorDetails errorDetails = this.createErrorDetails(exception.getMessage(), request);
        logger.warn("handleNotFoundExceptions Message:" + exception.getClass() + exception.getMessage());
        return new ResponseEntity((Object)errorDetails, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={MobileNumberAlreadyExistsException.class})
    public ResponseEntity<?> EmailAlreadyExistsException(MobileNumberAlreadyExistsException exception, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(Integer.valueOf(0), exception.getMessage());
        logger.warn("EmailAlreadyExistsException Message:" + exception.getClass() + exception.getMessage());
        return new ResponseEntity((Object)errorDetails, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={MobileNumberInvalidException.class})
    public ResponseEntity<?> MobileNumberInvalidException(MobileNumberInvalidException exception, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(Integer.valueOf(0), exception.getMessage());
        logger.warn("MobileNumberInvalidException Message:" + exception.getClass() + exception.getMessage());
        return new ResponseEntity((Object)errorDetails, (HttpStatusCode)HttpStatus.OK);
    }
}

