/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.entity;

import com.chataak.api.entity.Brand;
import com.chataak.api.entity.CategoryManager;
import com.chataak.api.entity.Organization;
import com.chataak.api.entity.OrganizationStoreEntity;
import com.chataak.api.entity.ProductAttribute;
import com.chataak.api.entity.ProductImage;
import com.chataak.api.entity.ProductVideo;
import com.chataak.api.entity.TaxClass;
import com.chataak.api.entity.Weight;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="catalog_products")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class Products {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="product_id")
    private Long productId;
    @ManyToOne
    @JoinColumn(name="organization_id")
    private Organization organization;
    @ManyToOne
    @JoinColumn(name="brand_id")
    private Brand brand;
    @Column(name="code", length=100)
    private String productCode;
    @Column(name="bar_code", length=100)
    private String barCode;
    @Column(name="name", length=50)
    private String productName;
    @Column(name="description", length=100)
    private String productDescription;
    @Column(name="sku", length=100)
    private String sku;
    @Column(name="selling_price", precision=38, scale=2)
    private BigDecimal sellingPrice;
    @Column(name="manufacturer_in")
    private String manufacturerIn;
    @Column(name="stock_status")
    private Boolean stockStatus;
    @Column(name="status")
    private Short status;
    @Column(name="quantity")
    private Integer quantity;
    @Column(name="is_configure")
    private boolean configure;
    @Column(name="hsn_code", length=10)
    private String hsnCode;
    @ManyToOne
    @JoinColumn(name="selling_uom", referencedColumnName="name")
    private Weight sellingUOM;
    @Column(name="no_unit_in_box")
    private Integer noUnitInBox;
    @Column(name="weight_status")
    private Boolean weightStatus;
    @Column(name="sp_per_unit")
    private BigDecimal spPerUnit;
    @Column(name="weight")
    private Double weight;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="catalog_product_categories", joinColumns={@JoinColumn(name="product_id")})
    @Column(name="category")
    private List<CategoryManager> categories;
    @OneToMany(mappedBy="products", fetch=FetchType.EAGER)
    @JsonManagedReference
    private List<OrganizationStoreEntity> stores = new ArrayList();
    @Column(name="sp_inclusive_tax")
    private Boolean spInclusiveTax;
    @Column(name="created_on")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="created_by")
    private Integer createdBy;
    @Column(name="modified_on")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modifiedOn;
    @Column(name="modified_by")
    private Integer modifiedBy;
    @Column(name="deleted_on")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedOn;
    @Column(name="deleted_by")
    private Integer deletedBy;
    @Column(name="min_order_quantity")
    private Integer minOrderQuantity;
    @OneToMany(mappedBy="product")
    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    private List<ProductAttribute> productAttributes = new ArrayList();
    @OneToMany(mappedBy="product")
    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    private List<ProductImage> productImages = new ArrayList();
    @OneToMany(mappedBy="product")
    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    private List<ProductVideo> productVideos = new ArrayList();
    @ManyToOne
    @JoinColumn(name="tax_class_id")
    private TaxClass taxClass;
    @Column(name="min_selling_price", precision=38, scale=2)
    private BigDecimal minSellingPrice;
    @Column(name="purchase_price", precision=38, scale=2)
    private BigDecimal purchasePrice;

    public Long getProductId() {
        return this.productId;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String getSku() {
        return this.sku;
    }

    public BigDecimal getSellingPrice() {
        return this.sellingPrice;
    }

    public String getManufacturerIn() {
        return this.manufacturerIn;
    }

    public Boolean getStockStatus() {
        return this.stockStatus;
    }

    public Short getStatus() {
        return this.status;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public boolean isConfigure() {
        return this.configure;
    }

    public String getHsnCode() {
        return this.hsnCode;
    }

    public Weight getSellingUOM() {
        return this.sellingUOM;
    }

    public Integer getNoUnitInBox() {
        return this.noUnitInBox;
    }

    public Boolean getWeightStatus() {
        return this.weightStatus;
    }

    public BigDecimal getSpPerUnit() {
        return this.spPerUnit;
    }

    public Double getWeight() {
        return this.weight;
    }

    public List<CategoryManager> getCategories() {
        return this.categories;
    }

    public List<OrganizationStoreEntity> getStores() {
        return this.stores;
    }

    public Boolean getSpInclusiveTax() {
        return this.spInclusiveTax;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Integer getCreatedBy() {
        return this.createdBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public Integer getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getDeletedOn() {
        return this.deletedOn;
    }

    public Integer getDeletedBy() {
        return this.deletedBy;
    }

    public Integer getMinOrderQuantity() {
        return this.minOrderQuantity;
    }

    public List<ProductAttribute> getProductAttributes() {
        return this.productAttributes;
    }

    public List<ProductImage> getProductImages() {
        return this.productImages;
    }

    public List<ProductVideo> getProductVideos() {
        return this.productVideos;
    }

    public TaxClass getTaxClass() {
        return this.taxClass;
    }

    public BigDecimal getMinSellingPrice() {
        return this.minSellingPrice;
    }

    public BigDecimal getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setSellingPrice(BigDecimal sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    public void setManufacturerIn(String manufacturerIn) {
        this.manufacturerIn = manufacturerIn;
    }

    public void setStockStatus(Boolean stockStatus) {
        this.stockStatus = stockStatus;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public void setConfigure(boolean configure) {
        this.configure = configure;
    }

    public void setHsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
    }

    public void setSellingUOM(Weight sellingUOM) {
        this.sellingUOM = sellingUOM;
    }

    public void setNoUnitInBox(Integer noUnitInBox) {
        this.noUnitInBox = noUnitInBox;
    }

    public void setWeightStatus(Boolean weightStatus) {
        this.weightStatus = weightStatus;
    }

    public void setSpPerUnit(BigDecimal spPerUnit) {
        this.spPerUnit = spPerUnit;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public void setCategories(List<CategoryManager> categories) {
        this.categories = categories;
    }

    public void setStores(List<OrganizationStoreEntity> stores) {
        this.stores = stores;
    }

    public void setSpInclusiveTax(Boolean spInclusiveTax) {
        this.spInclusiveTax = spInclusiveTax;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setModifiedBy(Integer modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setDeletedOn(Date deletedOn) {
        this.deletedOn = deletedOn;
    }

    public void setDeletedBy(Integer deletedBy) {
        this.deletedBy = deletedBy;
    }

    public void setMinOrderQuantity(Integer minOrderQuantity) {
        this.minOrderQuantity = minOrderQuantity;
    }

    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    public void setProductAttributes(List<ProductAttribute> productAttributes) {
        this.productAttributes = productAttributes;
    }

    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    public void setProductImages(List<ProductImage> productImages) {
        this.productImages = productImages;
    }

    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "product"})
    public void setProductVideos(List<ProductVideo> productVideos) {
        this.productVideos = productVideos;
    }

    public void setTaxClass(TaxClass taxClass) {
        this.taxClass = taxClass;
    }

    public void setMinSellingPrice(BigDecimal minSellingPrice) {
        this.minSellingPrice = minSellingPrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Products)) {
            return false;
        }
        Products other = (Products)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isConfigure() != other.isConfigure()) {
            return false;
        }
        Long this$productId = this.getProductId();
        Long other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !((Object)this$productId).equals(other$productId)) {
            return false;
        }
        Boolean this$stockStatus = this.getStockStatus();
        Boolean other$stockStatus = other.getStockStatus();
        if (this$stockStatus == null ? other$stockStatus != null : !((Object)this$stockStatus).equals(other$stockStatus)) {
            return false;
        }
        Short this$status = this.getStatus();
        Short other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Integer this$noUnitInBox = this.getNoUnitInBox();
        Integer other$noUnitInBox = other.getNoUnitInBox();
        if (this$noUnitInBox == null ? other$noUnitInBox != null : !((Object)this$noUnitInBox).equals(other$noUnitInBox)) {
            return false;
        }
        Boolean this$weightStatus = this.getWeightStatus();
        Boolean other$weightStatus = other.getWeightStatus();
        if (this$weightStatus == null ? other$weightStatus != null : !((Object)this$weightStatus).equals(other$weightStatus)) {
            return false;
        }
        Double this$weight = this.getWeight();
        Double other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        Boolean this$spInclusiveTax = this.getSpInclusiveTax();
        Boolean other$spInclusiveTax = other.getSpInclusiveTax();
        if (this$spInclusiveTax == null ? other$spInclusiveTax != null : !((Object)this$spInclusiveTax).equals(other$spInclusiveTax)) {
            return false;
        }
        Integer this$createdBy = this.getCreatedBy();
        Integer other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Integer this$modifiedBy = this.getModifiedBy();
        Integer other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !((Object)this$modifiedBy).equals(other$modifiedBy)) {
            return false;
        }
        Integer this$deletedBy = this.getDeletedBy();
        Integer other$deletedBy = other.getDeletedBy();
        if (this$deletedBy == null ? other$deletedBy != null : !((Object)this$deletedBy).equals(other$deletedBy)) {
            return false;
        }
        Integer this$minOrderQuantity = this.getMinOrderQuantity();
        Integer other$minOrderQuantity = other.getMinOrderQuantity();
        if (this$minOrderQuantity == null ? other$minOrderQuantity != null : !((Object)this$minOrderQuantity).equals(other$minOrderQuantity)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        Brand this$brand = this.getBrand();
        Brand other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        String this$barCode = this.getBarCode();
        String other$barCode = other.getBarCode();
        if (this$barCode == null ? other$barCode != null : !this$barCode.equals(other$barCode)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$productDescription = this.getProductDescription();
        String other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        BigDecimal this$sellingPrice = this.getSellingPrice();
        BigDecimal other$sellingPrice = other.getSellingPrice();
        if (this$sellingPrice == null ? other$sellingPrice != null : !((Object)this$sellingPrice).equals(other$sellingPrice)) {
            return false;
        }
        String this$manufacturerIn = this.getManufacturerIn();
        String other$manufacturerIn = other.getManufacturerIn();
        if (this$manufacturerIn == null ? other$manufacturerIn != null : !this$manufacturerIn.equals(other$manufacturerIn)) {
            return false;
        }
        String this$hsnCode = this.getHsnCode();
        String other$hsnCode = other.getHsnCode();
        if (this$hsnCode == null ? other$hsnCode != null : !this$hsnCode.equals(other$hsnCode)) {
            return false;
        }
        Weight this$sellingUOM = this.getSellingUOM();
        Weight other$sellingUOM = other.getSellingUOM();
        if (this$sellingUOM == null ? other$sellingUOM != null : !this$sellingUOM.equals(other$sellingUOM)) {
            return false;
        }
        BigDecimal this$spPerUnit = this.getSpPerUnit();
        BigDecimal other$spPerUnit = other.getSpPerUnit();
        if (this$spPerUnit == null ? other$spPerUnit != null : !((Object)this$spPerUnit).equals(other$spPerUnit)) {
            return false;
        }
        List this$categories = this.getCategories();
        List other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List this$stores = this.getStores();
        List other$stores = other.getStores();
        if (this$stores == null ? other$stores != null : !((Object)this$stores).equals(other$stores)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        Date this$deletedOn = this.getDeletedOn();
        Date other$deletedOn = other.getDeletedOn();
        if (this$deletedOn == null ? other$deletedOn != null : !((Object)this$deletedOn).equals(other$deletedOn)) {
            return false;
        }
        List this$productAttributes = this.getProductAttributes();
        List other$productAttributes = other.getProductAttributes();
        if (this$productAttributes == null ? other$productAttributes != null : !((Object)this$productAttributes).equals(other$productAttributes)) {
            return false;
        }
        List this$productImages = this.getProductImages();
        List other$productImages = other.getProductImages();
        if (this$productImages == null ? other$productImages != null : !((Object)this$productImages).equals(other$productImages)) {
            return false;
        }
        List this$productVideos = this.getProductVideos();
        List other$productVideos = other.getProductVideos();
        if (this$productVideos == null ? other$productVideos != null : !((Object)this$productVideos).equals(other$productVideos)) {
            return false;
        }
        TaxClass this$taxClass = this.getTaxClass();
        TaxClass other$taxClass = other.getTaxClass();
        if (this$taxClass == null ? other$taxClass != null : !this$taxClass.equals(other$taxClass)) {
            return false;
        }
        BigDecimal this$minSellingPrice = this.getMinSellingPrice();
        BigDecimal other$minSellingPrice = other.getMinSellingPrice();
        if (this$minSellingPrice == null ? other$minSellingPrice != null : !((Object)this$minSellingPrice).equals(other$minSellingPrice)) {
            return false;
        }
        BigDecimal this$purchasePrice = this.getPurchasePrice();
        BigDecimal other$purchasePrice = other.getPurchasePrice();
        return !(this$purchasePrice == null ? other$purchasePrice != null : !((Object)this$purchasePrice).equals(other$purchasePrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Products;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConfigure() ? 79 : 97);
        Long $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : ((Object)$productId).hashCode());
        Boolean $stockStatus = this.getStockStatus();
        result = result * 59 + ($stockStatus == null ? 43 : ((Object)$stockStatus).hashCode());
        Short $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Integer $noUnitInBox = this.getNoUnitInBox();
        result = result * 59 + ($noUnitInBox == null ? 43 : ((Object)$noUnitInBox).hashCode());
        Boolean $weightStatus = this.getWeightStatus();
        result = result * 59 + ($weightStatus == null ? 43 : ((Object)$weightStatus).hashCode());
        Double $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        Boolean $spInclusiveTax = this.getSpInclusiveTax();
        result = result * 59 + ($spInclusiveTax == null ? 43 : ((Object)$spInclusiveTax).hashCode());
        Integer $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Integer $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : ((Object)$modifiedBy).hashCode());
        Integer $deletedBy = this.getDeletedBy();
        result = result * 59 + ($deletedBy == null ? 43 : ((Object)$deletedBy).hashCode());
        Integer $minOrderQuantity = this.getMinOrderQuantity();
        result = result * 59 + ($minOrderQuantity == null ? 43 : ((Object)$minOrderQuantity).hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        Brand $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        String $barCode = this.getBarCode();
        result = result * 59 + ($barCode == null ? 43 : $barCode.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $productDescription = this.getProductDescription();
        result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        BigDecimal $sellingPrice = this.getSellingPrice();
        result = result * 59 + ($sellingPrice == null ? 43 : ((Object)$sellingPrice).hashCode());
        String $manufacturerIn = this.getManufacturerIn();
        result = result * 59 + ($manufacturerIn == null ? 43 : $manufacturerIn.hashCode());
        String $hsnCode = this.getHsnCode();
        result = result * 59 + ($hsnCode == null ? 43 : $hsnCode.hashCode());
        Weight $sellingUOM = this.getSellingUOM();
        result = result * 59 + ($sellingUOM == null ? 43 : $sellingUOM.hashCode());
        BigDecimal $spPerUnit = this.getSpPerUnit();
        result = result * 59 + ($spPerUnit == null ? 43 : ((Object)$spPerUnit).hashCode());
        List $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List $stores = this.getStores();
        result = result * 59 + ($stores == null ? 43 : ((Object)$stores).hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        Date $deletedOn = this.getDeletedOn();
        result = result * 59 + ($deletedOn == null ? 43 : ((Object)$deletedOn).hashCode());
        List $productAttributes = this.getProductAttributes();
        result = result * 59 + ($productAttributes == null ? 43 : ((Object)$productAttributes).hashCode());
        List $productImages = this.getProductImages();
        result = result * 59 + ($productImages == null ? 43 : ((Object)$productImages).hashCode());
        List $productVideos = this.getProductVideos();
        result = result * 59 + ($productVideos == null ? 43 : ((Object)$productVideos).hashCode());
        TaxClass $taxClass = this.getTaxClass();
        result = result * 59 + ($taxClass == null ? 43 : $taxClass.hashCode());
        BigDecimal $minSellingPrice = this.getMinSellingPrice();
        result = result * 59 + ($minSellingPrice == null ? 43 : ((Object)$minSellingPrice).hashCode());
        BigDecimal $purchasePrice = this.getPurchasePrice();
        result = result * 59 + ($purchasePrice == null ? 43 : ((Object)$purchasePrice).hashCode());
        return result;
    }

    public String toString() {
        return "Products(productId=" + this.getProductId() + ", organization=" + this.getOrganization() + ", brand=" + this.getBrand() + ", productCode=" + this.getProductCode() + ", barCode=" + this.getBarCode() + ", productName=" + this.getProductName() + ", productDescription=" + this.getProductDescription() + ", sku=" + this.getSku() + ", sellingPrice=" + this.getSellingPrice() + ", manufacturerIn=" + this.getManufacturerIn() + ", stockStatus=" + this.getStockStatus() + ", status=" + this.getStatus() + ", quantity=" + this.getQuantity() + ", configure=" + this.isConfigure() + ", hsnCode=" + this.getHsnCode() + ", sellingUOM=" + this.getSellingUOM() + ", noUnitInBox=" + this.getNoUnitInBox() + ", weightStatus=" + this.getWeightStatus() + ", spPerUnit=" + this.getSpPerUnit() + ", weight=" + this.getWeight() + ", categories=" + this.getCategories() + ", stores=" + this.getStores() + ", spInclusiveTax=" + this.getSpInclusiveTax() + ", createdOn=" + this.getCreatedOn() + ", createdBy=" + this.getCreatedBy() + ", modifiedOn=" + this.getModifiedOn() + ", modifiedBy=" + this.getModifiedBy() + ", deletedOn=" + this.getDeletedOn() + ", deletedBy=" + this.getDeletedBy() + ", minOrderQuantity=" + this.getMinOrderQuantity() + ", productAttributes=" + this.getProductAttributes() + ", productImages=" + this.getProductImages() + ", productVideos=" + this.getProductVideos() + ", taxClass=" + this.getTaxClass() + ", minSellingPrice=" + this.getMinSellingPrice() + ", purchasePrice=" + this.getPurchasePrice() + ")";
    }

    public Products(Long productId, Organization organization, Brand brand, String productCode, String barCode, String productName, String productDescription, String sku, BigDecimal sellingPrice, String manufacturerIn, Boolean stockStatus, Short status, Integer quantity, boolean configure, String hsnCode, Weight sellingUOM, Integer noUnitInBox, Boolean weightStatus, BigDecimal spPerUnit, Double weight, List<CategoryManager> categories, List<OrganizationStoreEntity> stores, Boolean spInclusiveTax, Date createdOn, Integer createdBy, Date modifiedOn, Integer modifiedBy, Date deletedOn, Integer deletedBy, Integer minOrderQuantity, List<ProductAttribute> productAttributes, List<ProductImage> productImages, List<ProductVideo> productVideos, TaxClass taxClass, BigDecimal minSellingPrice, BigDecimal purchasePrice) {
        this.productId = productId;
        this.organization = organization;
        this.brand = brand;
        this.productCode = productCode;
        this.barCode = barCode;
        this.productName = productName;
        this.productDescription = productDescription;
        this.sku = sku;
        this.sellingPrice = sellingPrice;
        this.manufacturerIn = manufacturerIn;
        this.stockStatus = stockStatus;
        this.status = status;
        this.quantity = quantity;
        this.configure = configure;
        this.hsnCode = hsnCode;
        this.sellingUOM = sellingUOM;
        this.noUnitInBox = noUnitInBox;
        this.weightStatus = weightStatus;
        this.spPerUnit = spPerUnit;
        this.weight = weight;
        this.categories = categories;
        this.stores = stores;
        this.spInclusiveTax = spInclusiveTax;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.modifiedOn = modifiedOn;
        this.modifiedBy = modifiedBy;
        this.deletedOn = deletedOn;
        this.deletedBy = deletedBy;
        this.minOrderQuantity = minOrderQuantity;
        this.productAttributes = productAttributes;
        this.productImages = productImages;
        this.productVideos = productVideos;
        this.taxClass = taxClass;
        this.minSellingPrice = minSellingPrice;
        this.purchasePrice = purchasePrice;
    }

    public Products() {
    }
}

