/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.entity;

import com.chataak.api.entity.Organization;
import com.chataak.api.entity.OrganizationStore;
import com.chataak.api.entity.Products;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="promotion")
public class ProductPromotion {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="promotion_id")
    private Integer promotionId;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="promotion_product", joinColumns={@JoinColumn(name="promotion_id")}, inverseJoinColumns={@JoinColumn(name="product_id")})
    private List<Products> product;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="promotion_store", joinColumns={@JoinColumn(name="promotion_id")}, inverseJoinColumns={@JoinColumn(name="store_key_id")})
    private List<OrganizationStore> store;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="organization_id")
    private Organization organization;
    @Column(name="code")
    private String promotionCode;
    @Column(name="name")
    private String promotionName;
    @Column(name="description")
    private String description;
    @Column(name="image_url")
    private String imageURL;
    @Column(name="valid_from")
    private Date validFrom;
    @Column(name="valid_till")
    private Date validTill;
    @Column(name="promotion_percentage")
    private BigDecimal promotionPercentage;
    @Column(name="promotion_type")
    private String promotionType;
    @Column(name="promotion_points")
    private BigDecimal promotionPoints;
    @Column(name="promotion_amount")
    private BigDecimal promotionAmount;
    @Column(name="status")
    private Short status;
    @Column(name="flag_type")
    private String flagType;
    @Column(name="country")
    private String country;
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="promotion_state", joinColumns={@JoinColumn(name="promotionId")})
    @Column(name="state")
    private List<String> state;
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="promotion_city", joinColumns={@JoinColumn(name="promotionId")})
    @Column(name="city")
    private List<String> city;
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="promotion_product_categories", joinColumns={@JoinColumn(name="promotionId")})
    @Column(name="categories")
    private List<String> categories;
    @Column(name="created_on", nullable=false, updatable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="created_by")
    private Integer createdBy;
    @Column(name="modified_on")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modifiedOn;
    @Column(name="modified_by")
    private Integer modifiedBy;
    @Column(name="deleted_on")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedOn;
    @Column(name="deleted_by")
    private Integer deletedBy;

    public ProductPromotion(Integer promotionId, List<Products> product, List<OrganizationStore> store, Organization organization, String promotionCode, String promotionName, String description, String imageURL, Date validFrom, Date validTill, BigDecimal promotionPercentage, String promotionType, BigDecimal promotionPoints, BigDecimal promotionAmount, Short status, String flagType, String country, List<String> state, List<String> city, List<String> categories, Date createdOn, Integer createdBy, Date modifiedOn, Integer modifiedBy, Date deletedOn, Integer deletedBy) {
        this.promotionId = promotionId;
        this.product = product;
        this.store = store;
        this.organization = organization;
        this.promotionCode = promotionCode;
        this.promotionName = promotionName;
        this.description = description;
        this.imageURL = imageURL;
        this.validFrom = validFrom;
        this.validTill = validTill;
        this.promotionPercentage = promotionPercentage;
        this.promotionType = promotionType;
        this.promotionPoints = promotionPoints;
        this.promotionAmount = promotionAmount;
        this.status = status;
        this.flagType = flagType;
        this.country = country;
        this.state = state;
        this.city = city;
        this.categories = categories;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.modifiedOn = modifiedOn;
        this.modifiedBy = modifiedBy;
        this.deletedOn = deletedOn;
        this.deletedBy = deletedBy;
    }

    public ProductPromotion() {
    }

    public Integer getPromotionId() {
        return this.promotionId;
    }

    public List<Products> getProduct() {
        return this.product;
    }

    public List<OrganizationStore> getStore() {
        return this.store;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public String getPromotionCode() {
        return this.promotionCode;
    }

    public String getPromotionName() {
        return this.promotionName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTill() {
        return this.validTill;
    }

    public BigDecimal getPromotionPercentage() {
        return this.promotionPercentage;
    }

    public String getPromotionType() {
        return this.promotionType;
    }

    public BigDecimal getPromotionPoints() {
        return this.promotionPoints;
    }

    public BigDecimal getPromotionAmount() {
        return this.promotionAmount;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getFlagType() {
        return this.flagType;
    }

    public String getCountry() {
        return this.country;
    }

    public List<String> getState() {
        return this.state;
    }

    public List<String> getCity() {
        return this.city;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Integer getCreatedBy() {
        return this.createdBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public Integer getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getDeletedOn() {
        return this.deletedOn;
    }

    public Integer getDeletedBy() {
        return this.deletedBy;
    }

    public void setPromotionId(Integer promotionId) {
        this.promotionId = promotionId;
    }

    @JsonIgnore
    public void setProduct(List<Products> product) {
        this.product = product;
    }

    @JsonIgnore
    public void setStore(List<OrganizationStore> store) {
        this.store = store;
    }

    @JsonIgnore
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setPromotionCode(String promotionCode) {
        this.promotionCode = promotionCode;
    }

    public void setPromotionName(String promotionName) {
        this.promotionName = promotionName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTill(Date validTill) {
        this.validTill = validTill;
    }

    public void setPromotionPercentage(BigDecimal promotionPercentage) {
        this.promotionPercentage = promotionPercentage;
    }

    public void setPromotionType(String promotionType) {
        this.promotionType = promotionType;
    }

    public void setPromotionPoints(BigDecimal promotionPoints) {
        this.promotionPoints = promotionPoints;
    }

    public void setPromotionAmount(BigDecimal promotionAmount) {
        this.promotionAmount = promotionAmount;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setFlagType(String flagType) {
        this.flagType = flagType;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setState(List<String> state) {
        this.state = state;
    }

    public void setCity(List<String> city) {
        this.city = city;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setModifiedBy(Integer modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setDeletedOn(Date deletedOn) {
        this.deletedOn = deletedOn;
    }

    public void setDeletedBy(Integer deletedBy) {
        this.deletedBy = deletedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductPromotion)) {
            return false;
        }
        ProductPromotion other = (ProductPromotion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$promotionId = this.getPromotionId();
        Integer other$promotionId = other.getPromotionId();
        if (this$promotionId == null ? other$promotionId != null : !((Object)this$promotionId).equals(other$promotionId)) {
            return false;
        }
        Short this$status = this.getStatus();
        Short other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$createdBy = this.getCreatedBy();
        Integer other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Integer this$modifiedBy = this.getModifiedBy();
        Integer other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !((Object)this$modifiedBy).equals(other$modifiedBy)) {
            return false;
        }
        Integer this$deletedBy = this.getDeletedBy();
        Integer other$deletedBy = other.getDeletedBy();
        if (this$deletedBy == null ? other$deletedBy != null : !((Object)this$deletedBy).equals(other$deletedBy)) {
            return false;
        }
        List this$product = this.getProduct();
        List other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        List this$store = this.getStore();
        List other$store = other.getStore();
        if (this$store == null ? other$store != null : !((Object)this$store).equals(other$store)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$promotionCode = this.getPromotionCode();
        String other$promotionCode = other.getPromotionCode();
        if (this$promotionCode == null ? other$promotionCode != null : !this$promotionCode.equals(other$promotionCode)) {
            return false;
        }
        String this$promotionName = this.getPromotionName();
        String other$promotionName = other.getPromotionName();
        if (this$promotionName == null ? other$promotionName != null : !this$promotionName.equals(other$promotionName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$imageURL = this.getImageURL();
        String other$imageURL = other.getImageURL();
        if (this$imageURL == null ? other$imageURL != null : !this$imageURL.equals(other$imageURL)) {
            return false;
        }
        Date this$validFrom = this.getValidFrom();
        Date other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !((Object)this$validFrom).equals(other$validFrom)) {
            return false;
        }
        Date this$validTill = this.getValidTill();
        Date other$validTill = other.getValidTill();
        if (this$validTill == null ? other$validTill != null : !((Object)this$validTill).equals(other$validTill)) {
            return false;
        }
        BigDecimal this$promotionPercentage = this.getPromotionPercentage();
        BigDecimal other$promotionPercentage = other.getPromotionPercentage();
        if (this$promotionPercentage == null ? other$promotionPercentage != null : !((Object)this$promotionPercentage).equals(other$promotionPercentage)) {
            return false;
        }
        String this$promotionType = this.getPromotionType();
        String other$promotionType = other.getPromotionType();
        if (this$promotionType == null ? other$promotionType != null : !this$promotionType.equals(other$promotionType)) {
            return false;
        }
        BigDecimal this$promotionPoints = this.getPromotionPoints();
        BigDecimal other$promotionPoints = other.getPromotionPoints();
        if (this$promotionPoints == null ? other$promotionPoints != null : !((Object)this$promotionPoints).equals(other$promotionPoints)) {
            return false;
        }
        BigDecimal this$promotionAmount = this.getPromotionAmount();
        BigDecimal other$promotionAmount = other.getPromotionAmount();
        if (this$promotionAmount == null ? other$promotionAmount != null : !((Object)this$promotionAmount).equals(other$promotionAmount)) {
            return false;
        }
        String this$flagType = this.getFlagType();
        String other$flagType = other.getFlagType();
        if (this$flagType == null ? other$flagType != null : !this$flagType.equals(other$flagType)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        List this$state = this.getState();
        List other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        List this$city = this.getCity();
        List other$city = other.getCity();
        if (this$city == null ? other$city != null : !((Object)this$city).equals(other$city)) {
            return false;
        }
        List this$categories = this.getCategories();
        List other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        Date this$deletedOn = this.getDeletedOn();
        Date other$deletedOn = other.getDeletedOn();
        return !(this$deletedOn == null ? other$deletedOn != null : !((Object)this$deletedOn).equals(other$deletedOn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductPromotion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $promotionId = this.getPromotionId();
        result = result * 59 + ($promotionId == null ? 43 : ((Object)$promotionId).hashCode());
        Short $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Integer $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : ((Object)$modifiedBy).hashCode());
        Integer $deletedBy = this.getDeletedBy();
        result = result * 59 + ($deletedBy == null ? 43 : ((Object)$deletedBy).hashCode());
        List $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        List $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $promotionCode = this.getPromotionCode();
        result = result * 59 + ($promotionCode == null ? 43 : $promotionCode.hashCode());
        String $promotionName = this.getPromotionName();
        result = result * 59 + ($promotionName == null ? 43 : $promotionName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $imageURL = this.getImageURL();
        result = result * 59 + ($imageURL == null ? 43 : $imageURL.hashCode());
        Date $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : ((Object)$validFrom).hashCode());
        Date $validTill = this.getValidTill();
        result = result * 59 + ($validTill == null ? 43 : ((Object)$validTill).hashCode());
        BigDecimal $promotionPercentage = this.getPromotionPercentage();
        result = result * 59 + ($promotionPercentage == null ? 43 : ((Object)$promotionPercentage).hashCode());
        String $promotionType = this.getPromotionType();
        result = result * 59 + ($promotionType == null ? 43 : $promotionType.hashCode());
        BigDecimal $promotionPoints = this.getPromotionPoints();
        result = result * 59 + ($promotionPoints == null ? 43 : ((Object)$promotionPoints).hashCode());
        BigDecimal $promotionAmount = this.getPromotionAmount();
        result = result * 59 + ($promotionAmount == null ? 43 : ((Object)$promotionAmount).hashCode());
        String $flagType = this.getFlagType();
        result = result * 59 + ($flagType == null ? 43 : $flagType.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        List $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        List $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
        List $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        Date $deletedOn = this.getDeletedOn();
        result = result * 59 + ($deletedOn == null ? 43 : ((Object)$deletedOn).hashCode());
        return result;
    }

    public String toString() {
        return "ProductPromotion(promotionId=" + this.getPromotionId() + ", product=" + this.getProduct() + ", store=" + this.getStore() + ", organization=" + this.getOrganization() + ", promotionCode=" + this.getPromotionCode() + ", promotionName=" + this.getPromotionName() + ", description=" + this.getDescription() + ", imageURL=" + this.getImageURL() + ", validFrom=" + this.getValidFrom() + ", validTill=" + this.getValidTill() + ", promotionPercentage=" + this.getPromotionPercentage() + ", promotionType=" + this.getPromotionType() + ", promotionPoints=" + this.getPromotionPoints() + ", promotionAmount=" + this.getPromotionAmount() + ", status=" + this.getStatus() + ", flagType=" + this.getFlagType() + ", country=" + this.getCountry() + ", state=" + this.getState() + ", city=" + this.getCity() + ", categories=" + this.getCategories() + ", createdOn=" + this.getCreatedOn() + ", createdBy=" + this.getCreatedBy() + ", modifiedOn=" + this.getModifiedOn() + ", modifiedBy=" + this.getModifiedBy() + ", deletedOn=" + this.getDeletedOn() + ", deletedBy=" + this.getDeletedBy() + ")";
    }
}

