/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.ResponseOTP;
import com.chataak.api.dto.UserDTO;
import com.chataak.api.entity.SessionHistory;
import com.chataak.api.entity.User;
import com.chataak.api.repo.SessionHistoryRepository;
import com.chataak.api.repo.UserRepository;
import com.chataak.api.service.JwtService;
import com.chataak.api.service.UserService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private final UserService userService;
    private final JwtService jwtService;
    private final UserRepository userRepository;
    private final SessionHistoryRepository historyRepository;

    @Autowired
    public UserController(UserService userService, JwtService jwtService, UserRepository userRepository, SessionHistoryRepository historyRepository) {
        this.userService = userService;
        this.jwtService = jwtService;
        this.userRepository = userRepository;
        this.historyRepository = historyRepository;
    }

    @GetMapping
    public ResponseEntity<List<User>> getAllUsers() {
        List users = this.userService.getAllUsers();
        if (!users.isEmpty()) {
            return ResponseEntity.ok((Object)users);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<UserDTO> createUser(@RequestBody UserDTO userDTO) {
        return ResponseEntity.ok((Object)this.userService.createUser(userDTO));
    }

    @PutMapping(value={"/{userId}"})
    public ResponseEntity<ResponseOTP> updateUser(@PathVariable int userId, @RequestBody UserDTO userDTO) {
        logger.info("Received User Update request /api/users/{userId} with userId-" + userId);
        UserDTO user = this.userService.updateUser(userId, userDTO);
        ResponseOTP responseOTP = new ResponseOTP();
        responseOTP.setStatus(Integer.valueOf(1));
        responseOTP.setMessage("profile updated successfull");
        logger.info("profile updated request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @PutMapping(value={"/image/{userId}"})
    public ResponseEntity<ResponseOTP> updateUser(@PathVariable int userId, @RequestParam MultipartFile image) throws Exception {
        logger.info("Received User imageUpdate request /api/users/image/{userId} with userId-" + userId);
        UserDTO user = this.userService.userUpdateFile(userId, image);
        ResponseOTP responseOTP = new ResponseOTP();
        responseOTP.setStatus(Integer.valueOf(1));
        responseOTP.setMessage("profile updated successfull");
        logger.info("profile image updated request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @DeleteMapping(value={"/{userId}"})
    public ResponseEntity<?> deleteUser(@PathVariable int userId) {
        this.userService.deleteUser(userId);
        return new ResponseEntity((Object)"User is Deleted successfully", (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{userId}/get-profile-info"})
    public ResponseEntity<UserDTO> getProfileInfo(@PathVariable int userId) {
        logger.info("Received User Profile Info request /api/users/{userId}/get-profile-info with userId-" + userId);
        UserDTO userProfile = this.userService.getProfileInfo(userId);
        if (userProfile != null) {
            logger.info("User Profile Info request successful.");
            return ResponseEntity.ok((Object)userProfile);
        }
        logger.warn("User Profile Info request error.");
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{userId}/cancel-account"})
    public ResponseEntity<ResponseOTP> cancelAccount(@PathVariable int userId) {
        logger.info("Received User cancel Account request /api/users/{userId}/cancel-account with userId-" + userId);
        ResponseOTP responseOTP = this.userService.cancelAccount(userId);
        if (responseOTP.getStatus() == 1) {
            logger.info("User cancel Account request successful.");
            return ResponseEntity.ok((Object)responseOTP);
        }
        logger.warn("User cancel Account request error:" + responseOTP);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)responseOTP);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<?> logout(@RequestHeader(value="Authorization") String token) {
        if (token != null && token.startsWith("Bearer ")) {
            String username = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
            Optional user = this.userRepository.findByMobileNumber(username);
            List histories = this.historyRepository.findByUser((User)user.get());
            if (!histories.isEmpty()) {
                SessionHistory sessionHistory = (SessionHistory)histories.get(histories.size() - 1);
                sessionHistory.setLogoutDateTime(new Date());
                this.historyRepository.save((Object)sessionHistory);
            }
            token = token.substring(7);
            this.jwtService.revokeToken(token);
            ResponseOTP responseOTP = new ResponseOTP();
            int i = 1;
            responseOTP.setStatus(Integer.valueOf(i));
            responseOTP.setMessage("Logged out successfully");
            return ResponseEntity.ok((Object)responseOTP);
        }
        ResponseOTP responseOTP = new ResponseOTP();
        int i = 1;
        responseOTP.setStatus(Integer.valueOf(i));
        responseOTP.setMessage("Invalid token");
        return ResponseEntity.badRequest().body((Object)responseOTP);
    }
}

