/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.CartBillDTO;
import com.chataak.api.dto.CartDTO;
import com.chataak.api.dto.PaymentDto;
import com.chataak.api.dto.ResponseOTP;
import com.chataak.api.dto.ShopCartDTO;
import com.chataak.api.entity.ShoppingCartProducts;
import com.chataak.api.service.ShoppingCartProductsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ShoppingCartProductsController {
    private static final Logger logger = LoggerFactory.getLogger(ShoppingCartProductsController.class);
    @Autowired
    private ShoppingCartProductsService shoppingCartProductsServiceImpl;

    @GetMapping(value={"api/stores/{storeKeyId}/{userKeyId}/shopping-cart/count"})
    public ResponseEntity<Map<String, Long>> countProducts(@PathVariable Integer storeKeyId, @PathVariable Integer userKeyId) {
        logger.info("Received Count of Product in cart request api/stores/{storeKeyId}/{userKeyId}/shopping-cart/count with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId);
        long count = this.shoppingCartProductsServiceImpl.countProductsByUserAndStore(userKeyId, storeKeyId);
        HashMap<String, Long> response = new HashMap<String, Long>();
        response.put("count", count);
        logger.info("Count of Product in cart  request successful.");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/api/store/{storeKeyId}/{userKeyId}/shopping-cart/add-to-cart"})
    public ResponseEntity<CartDTO> addProductToCart(@PathVariable Integer userKeyId, @PathVariable Integer storeKeyId, @RequestBody ShopCartDTO products) {
        logger.info("Received Add Product to cart request /api/store/{storeKeyId}/{userKeyId}/shopping-cart/add-to-cart with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId + ", productKeyId" + products.getProduct().getProductKeyId());
        CartDTO cartDTO = this.shoppingCartProductsServiceImpl.addProductToCart(userKeyId, storeKeyId, products);
        if (cartDTO != null) {
            logger.info("Add Product to cart request successful.");
            return ResponseEntity.ok((Object)cartDTO);
        }
        logger.warn("Add Product to cart request error.");
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/api/store/{storeKeyId}/{userKeyId}/shopping-cart/remove"})
    public ResponseEntity<ResponseOTP> removeCartProducts(@PathVariable Integer storeKeyId, @PathVariable Integer userKeyId, @RequestBody ShoppingCartProducts products) {
        logger.info("Received Remove Product from cart request /api/store/{storeKeyId}/{userKeyId}/shopping-cart/remove with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId + ", productKeyId" + products.getProduct().getProductId());
        this.shoppingCartProductsServiceImpl.removeCartProducts(storeKeyId, userKeyId, products.getProduct().getProductId());
        ResponseOTP responseOTP = new ResponseOTP();
        responseOTP.setStatus(Integer.valueOf(1));
        responseOTP.setMessage("Cart item successfully removed");
        logger.info("Remove Product from cart request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @PutMapping(value={"/api/store/{storeKeyId}/{userKeyId}/shopping-cart/update"})
    public ResponseEntity<?> updateCartItem(@PathVariable Integer storeKeyId, @PathVariable Integer userKeyId, @RequestBody ShopCartDTO products) {
        logger.info("Received Update Product to cart request /api/store/{storeKeyId}/{userKeyId}/shopping-cart/update with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId + ", productKeyId" + products.getProduct().getProductKeyId());
        String updated = this.shoppingCartProductsServiceImpl.updateCartProducts(storeKeyId, userKeyId, products);
        if (updated == null) {
            logger.warn("Update Product to cart request error.");
            return ResponseEntity.notFound().build();
        }
        ResponseOTP responseOTP = new ResponseOTP();
        responseOTP.setStatus(Integer.valueOf(1));
        responseOTP.setMessage(updated);
        logger.info("Update Product to cart request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @PutMapping(value={"/api/store/{storeKeyId}/{userKeyId}/shopping-cart/recalculate"})
    public ResponseEntity<?> recalculateCart(@PathVariable Integer storeKeyId, @PathVariable Integer userKeyId) {
        logger.info("Received recalculate for cart request /api/store/{storeKeyId}/{userKeyId}/shopping-cart/recalculate with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId);
        boolean updated = this.shoppingCartProductsServiceImpl.recalculateCart(userKeyId, storeKeyId);
        ResponseOTP responseOTP = new ResponseOTP();
        if (!updated) {
            responseOTP.setStatus(Integer.valueOf(1));
            responseOTP.setMessage(null);
            logger.warn("recalculate for cart request noting change.");
            return ResponseEntity.ok((Object)responseOTP);
        }
        responseOTP.setStatus(Integer.valueOf(0));
        responseOTP.setMessage("Your cart quantity, value, or availability has changed, kindly review your cart!");
        logger.info("recalculate for cart request successful.");
        return ResponseEntity.ok((Object)responseOTP);
    }

    @GetMapping(value={"/api/stores/{storeKeyId}/{userKeyId}/shopping-cart"})
    public ResponseEntity<?> getShoppingCart(@PathVariable Integer userKeyId, @PathVariable Integer storeKeyId) {
        logger.info("Received Shopping Cart view request /api/stores/{storeKeyId}/{userKeyId}/shopping-cart with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId);
        List shoppingCartDetails = this.shoppingCartProductsServiceImpl.getShoppingCart(userKeyId, storeKeyId);
        logger.info("Shopping Cart request successful.");
        return ResponseEntity.ok((Object)shoppingCartDetails);
    }

    @GetMapping(value={"/api/stores/{storeKeyId}/{userKeyId}/shopping-cart-summary"})
    public ResponseEntity<?> getShoppingCartSummary(@PathVariable Integer userKeyId, @PathVariable Integer storeKeyId) {
        logger.info("Received Shopping Cart summary request /api/stores/{storeKeyId}/{userKeyId}/shopping-cart-summary with userKeyId-" + userKeyId + ", storeKeyId-" + storeKeyId);
        Map cartSummary = this.shoppingCartProductsServiceImpl.getShoppingCartSummary(userKeyId, storeKeyId);
        logger.info("Shopping Cart summary request successful.");
        return ResponseEntity.ok((Object)cartSummary);
    }

    @PostMapping(value={"/api/payment/{cartKeyId}"})
    public ResponseEntity<PaymentDto> processPayment(@PathVariable int cartKeyId, @RequestBody PaymentDto paymentDto) {
        logger.info("Received Payment request /api/payment/{cartKeyId} with cartKeyId-" + cartKeyId);
        PaymentDto paymentDtoResponseEntity = this.shoppingCartProductsServiceImpl.processPayment(cartKeyId, paymentDto);
        logger.info("Payment request successful.");
        return new ResponseEntity((Object)paymentDtoResponseEntity, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/api/stores/{cartKeyId}/shopping-cart-bill"})
    public ResponseEntity<?> getBillOfCart(@PathVariable int cartKeyId) {
        logger.info("Received Shopping Cart Bill request /api/stores/{cartKeyId}/shopping-cart-bill.");
        CartBillDTO billOfCart = this.shoppingCartProductsServiceImpl.getBillOfCart(Integer.valueOf(cartKeyId));
        logger.info("Shopping Cart Bill request successful.");
        return new ResponseEntity((Object)billOfCart, (HttpStatusCode)HttpStatus.OK);
    }
}

