/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.ScanDTO;
import com.chataak.api.service.ProductsService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductsController {
    private static final Logger logger = LoggerFactory.getLogger(ProductsController.class);
    @Autowired
    private ProductsService productsServiceImpl;

    @GetMapping(value={"/api/product/{productKeyId}/{storeKeyId}/scan"})
    public ResponseEntity<Map<String, List<?>>> scanProduct(@PathVariable long productKeyId, @PathVariable Integer storeKeyId, @RequestParam(defaultValue="1") Integer quantity, @RequestParam(defaultValue="0") Integer promotionKeyId) {
        logger.info("Received scan Product request /api/product/{productKeyId}/{storeKeyId}/scan with productKeyId-{" + productKeyId + "}, storeKeyId-{" + storeKeyId + "},quantity-" + quantity);
        Map responseDto = this.productsServiceImpl.scanProductByBarcode(productKeyId, storeKeyId, quantity, promotionKeyId);
        if (responseDto != null) {
            logger.info("Scan Product request successful.");
            return ResponseEntity.ok((Object)responseDto);
        }
        logger.warn("Scan Product not found.");
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/api/product/scan/scanQR"})
    public ResponseEntity<?> scanProductsByBarcode(@RequestBody ScanDTO scanDTO) {
        logger.info("Received Barcode scan Product request /api/product/scan/scanQR with scanDTO-" + scanDTO.getBarcode());
        Map stringStringMap = this.productsServiceImpl.scanProductsByBarcode(scanDTO.getBarcode(), scanDTO.getStoreKeyId());
        if (stringStringMap != null) {
            logger.info("Barcode Scan Product request successful.");
            return ResponseEntity.ok((Object)stringStringMap);
        }
        logger.warn("Barcode Scan Product not found.");
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"api/store/{storeKeyId}/product/{productKeyId}/relatedProducts"})
    public List<Map<String, Object>> getRelatedProducts(@PathVariable Long productKeyId, @PathVariable Integer storeKeyId) {
        logger.info("Received Related Product request api/store/{storeKeyId}/product/{productKeyId}/relatedProducts with productKeyId-" + productKeyId + ", storeKeyId-" + storeKeyId);
        List similarProducts = this.productsServiceImpl.getSimilarProducts(productKeyId, storeKeyId);
        logger.info("Related Product request successful.");
        return similarProducts;
    }

    @PutMapping(value={"/api/product/{productKeyId}"})
    public ResponseEntity<?> update(@PathVariable Long productKeyId, @RequestParam BigDecimal sellingPrice, @RequestParam int quantity) {
        this.productsServiceImpl.update(productKeyId, sellingPrice, quantity);
        return ResponseEntity.ok().build();
    }
}

