/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.dto.OrderBillDTO;
import com.chataak.api.dto.OrderDto;
import com.chataak.api.dto.OrderListDTO;
import com.chataak.api.entity.Order;
import com.chataak.api.service.OrderService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class OrderController {
    private static final Logger logger = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private OrderService orderService;

    public OrderController(OrderService orderService) {
        this.orderService = orderService;
    }

    @PostMapping(value={"/{userKeyId}/{cartKeyId}/orders/create-order"})
    public ResponseEntity<Map<String, Object>> createOrder(@PathVariable int userKeyId, @PathVariable Integer cartKeyId) {
        logger.info("Received Create Order request /api/user/{userKeyId}/{cartKeyId}/orders/create-order");
        Map order1 = this.orderService.createOrder(userKeyId, cartKeyId);
        logger.info("Create Order request successful.");
        return ResponseEntity.ok((Object)order1);
    }

    @PutMapping(value={"/{userKeyId}/orders/{orderKeyId}/update-order"})
    public ResponseEntity<String> updateOrder(@PathVariable int userKeyId, @PathVariable int orderKeyId, @RequestBody Order order) {
        logger.info("Received Update Order request /api/user/{userKeyId}/orders/{orderKeyId}/update-order");
        this.orderService.updateOrder(userKeyId, order, orderKeyId);
        logger.info("Get Order Info request successful.");
        return ResponseEntity.ok((Object)"Order updated successfully");
    }

    @GetMapping(value={"/{userKeyId}/orders/{orderKeyId}/get-order-info"})
    public ResponseEntity<List<OrderDto>> getOrderInfo(@PathVariable int userKeyId, @PathVariable Long orderKeyId) {
        logger.info("Received Get Order Info request /api/user/{userKeyId}/orders/{orderKeyId}/get-order-info");
        List order = this.orderService.getOrderInfo(userKeyId, orderKeyId);
        logger.info("Get Order Info request successful.");
        return ResponseEntity.ok((Object)order);
    }

    @GetMapping(value={"/{userKeyId}/orders/get-all-order-list"})
    public ResponseEntity<List<OrderListDTO>> getAllOrderList(@PathVariable Integer userKeyId) {
        logger.info("Received Get All Order List request /api/user/{userKeyId}/orders/get-all-order-list");
        List orderList = this.orderService.getAllOrderList(userKeyId);
        logger.info("Get All Order List request successful.");
        return ResponseEntity.ok((Object)orderList);
    }

    @GetMapping(value={"/{userKeyId}/orders/{orderKeyId}/get-order-bill"})
    public ResponseEntity<OrderBillDTO> getOrderBill(@PathVariable int userKeyId, @PathVariable Long orderKeyId) {
        logger.info("Received Get Order bill request /api/user/{userKeyId}/orders/{orderKeyId}/get-order-bill");
        OrderBillDTO orderBill = this.orderService.getOrderBill(userKeyId, orderKeyId);
        logger.info("Get Order bill request successful.");
        return ResponseEntity.ok((Object)orderBill);
    }
}

