/*
 * Decompiled with CFR 0.152.
 */
package com.chataak.api.controller;

import com.chataak.api.service.InvoiceService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/invoices"})
public class InvoiceController {
    @Autowired
    private InvoiceService invoiceServiceImpl;

    @PostMapping(value={"/{orderKeyId}/generate"})
    public ResponseEntity<Map<String, String>> generateInvoice(@PathVariable Integer orderKeyId) throws Exception {
        String invoiceUrl = this.invoiceServiceImpl.generateInvoicePDF(orderKeyId);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("url", invoiceUrl);
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/retrieve"})
    public ResponseEntity<Map<String, String>> getInvoiceUrl(@RequestParam(required=false) Long invoiceId, @RequestParam(required=false) Integer orderKeyId) {
        Map invoiceUrlResponse = this.invoiceServiceImpl.getInvoiceUrl(invoiceId, orderKeyId);
        return ResponseEntity.ok((Object)invoiceUrlResponse);
    }
}

